/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.concepts;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.util.Pair;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.cache.annotations.Cacheable;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;
import net.enilink.vocab.rdfs.Resource;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

@Iri(value="http://www.w3.org/2000/01/rdf-schema#Resource")
public interface IResource
extends Resource {
    public static final Comparator<IReference> RANK_COMPARATOR = new Comparator<IReference>(){
        URI[] defaultNamespaces = new URI[]{XMLSCHEMA.NAMESPACE_URI, RDF.NAMESPACE_URI, RDFS.NAMESPACE_URI, OWL.NAMESPACE_URI};

        @Override
        public int compare(IReference a, IReference b) {
            URI aUri = a.getURI();
            URI bUri = b.getURI();
            if (aUri == null) {
                if (bUri != null) {
                    return 1;
                }
                return 0;
            }
            if (bUri == null) {
                return -1;
            }
            return this.getRank(bUri.namespace()) - this.getRank(aUri.namespace());
        }

        int getRank(URI namespace) {
            for (int i = 0; i < this.defaultNamespaces.length; ++i) {
                if (!namespace.equals((Object)this.defaultNamespaces[i])) continue;
                return i;
            }
            return this.defaultNamespaces.length + 1;
        }
    };

    @Iri(value="http://enilink.net/vocab/komma#image")
    public java.net.URI getImage();

    public void addProperty(IReference var1, Object var2);

    @Cacheable
    public Pair<Integer, Integer> getApplicableCardinality(IReference var1);

    public IExtendedIterator<IProperty> getRelevantProperties();

    public int getCardinality(IReference var1);

    public IExtendedIterator<IClass> getNamedClasses();

    @Cacheable(key="komma:directNamedClasses")
    public IExtendedIterator<IClass> getDirectNamedClasses();

    public IExtendedIterator<IClass> getClasses();

    @Cacheable
    public IExtendedIterator<IClass> getClasses(boolean var1);

    @Cacheable(key="komma:directClasses")
    public IExtendedIterator<IClass> getDirectClasses();

    public IExtendedIterator<IValue> getPropertyValues(IReference var1, boolean var2);

    public IExtendedIterator<IStatement> getPropertyStatements(IReference var1, boolean var2);

    public IExtendedIterator<IStatement> getInversePropertyStatements(IReference var1, boolean var2);

    public IExtendedIterator<IStatement> getInversePropertyStatements(IReference var1, boolean var2, boolean var3);

    public boolean hasApplicableProperty(IReference var1);

    public boolean hasProperty(IReference var1, Object var2, boolean var3);

    public boolean isOntLanguageTerm();

    public boolean isPropertySet(IReference var1, boolean var2);

    public void removeProperty(IReference var1, Object var2);

    public void removeProperty(IReference var1);

    public Object get(IReference var1);

    public Object getSingle(IReference var1);

    public Set<Object> getAsSet(IReference var1);

    public void refresh(IReference var1);

    public void set(IReference var1, Object var2);

    @Iri(value="http://enilink.net/vocab/komma#containsTransitive")
    public Set<IResource> getAllContents();

    public IExtendedIterator<IProperty> getApplicableChildProperties();

    public IResource getContainer();

    @Iri(value="http://enilink.net/vocab/komma#contains")
    public Set<IResource> getContents();

    public List<IResource> getOrderedContents();

    public void setOrderedContents();

    @Iri(value="http://enilink.net/vocab/komma#precedes")
    public Set<IResource> getPrecedes();

    @Iri(value="http://enilink.net/vocab/komma#precedesTransitive")
    public Set<IResource> getPrecedesTransitive();

    public void setContents(Set<IResource> var1);

    public void setPrecedes(Set<IResource> var1);
}

