/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.concepts;

import java.util.Collection;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.concepts.BehaviorBase;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IOntology;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.vocab.owl.DatatypeProperty;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.owl.ObjectProperty;

public abstract class OntologySupport
extends BehaviorBase
implements IOntology {
    private static final String SELECT_PROPERTIES() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?p WHERE {?p a ?propertyType . FILTER NOT EXISTS {\t\t?p a ?otherType . ?otherType rdfs:subClassOf ?propertyType \t\tFILTER (?propertyType = owl:ObjectProperty && (?otherType = owl:AnnotationProperty || ?otherType = owl:DatatypeProperty || ?otherType = rdfs:ContainerMembershipProperty))}FILTER NOT EXISTS {\t\t?p rdfs:subPropertyOf ?other \t\tFILTER (?other != owl:topObjectProperty && ?other != owl:topDataProperty && ?p != ?other && isIRI(?other))} FILTER (?p != owl:topObjectProperty && ?p != owl:topDataProperty)}";
    }

    @Override
    public Collection<IClass> getRootClasses() {
        return ((IClass)this.getEntityManager().find((IReference)OWL.TYPE_THING, IClass.class, new Class[0])).getSubClasses(true, true).toList();
    }

    @Override
    public IExtendedIterator<IProperty> getRootProperties() {
        IQuery query = this.getEntityManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?p WHERE {?p a ?type { ?type rdfs:subClassOf* rdf:Property } UNION { ?p a rdf:Property } FILTER NOT EXISTS { ?p rdfs:subPropertyOf ?other FILTER (?p != ?other && isIRI(?other))} FILTER (isIRI(?p) && (?type = owl:AnnotationProperty || !regex(str(?type), 'http://www.w3.org/2002/07/owl#')))}", false);
        return query.evaluate(IProperty.class, new Class[0]);
    }

    @Override
    public IExtendedIterator<IProperty> getRootObjectProperties() {
        IQuery query = (IQuery)this.getEntityManager().createQuery(OntologySupport.SELECT_PROPERTIES(), false).setParameter("propertyType", (Object)OWL.TYPE_OBJECTPROPERTY);
        return query.evaluate(IProperty.class, new Class[]{ObjectProperty.class});
    }

    @Override
    public IExtendedIterator<IProperty> getRootDatatypeProperties() {
        IQuery query = (IQuery)this.getEntityManager().createQuery(OntologySupport.SELECT_PROPERTIES(), false).setParameter("propertyType", (Object)OWL.TYPE_DATATYPEPROPERTY);
        return query.evaluate(IProperty.class, new Class[]{DatatypeProperty.class});
    }
}

