/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.concepts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.concepts.BehaviorBase;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.vocab.komma.KOMMA;
import net.enilink.vocab.owl.Class;
import net.enilink.vocab.owl.DatatypeProperty;
import net.enilink.vocab.owl.FunctionalProperty;

public abstract class PropertySupport
extends BehaviorBase
implements IProperty,
Behaviour<IProperty> {
    private static final String IS_CONTAINMENT = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?property rdfs:subPropertyOf komma:contains }";
    private static final String IS_ORDERED_CONTAINMENT = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { { ?property rdfs:subPropertyOf komma:orderedContains } }";
    private static final String IS_RANGE_INSTANCE = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?object a ?class .  { ?property rdfs:range ?class } UNION { ?class rdfs:subClassOf ?superClass . ?property rdfs:range ?superClass } }";
    private static final String IS_DOMAIN_INSTANCE = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?object a ?domain .?property rdfs:domain ?domain  }";
    private static final String HAS_LIST_RANGE_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { { ?property rdfs:range rdf:List } UNION { ?property rdfs:range rdfs:Container } }";
    private static final String DIRECT_RANGE_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?range WHERE { ?property rdfs:range ?range FILTER NOT EXISTS { ?property rdfs:range ?otherRange . ?range rdfs:subClassOf ?otherRange FILTER (?range != ?otherRange) } }";
    private static final String RANGE_QUERY = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?range WHERE { ?property rdfs:range ?range  }";

    private static final String SELECT_DIRECT_SUBPROPERTIES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?subProperty WHERE { ?subProperty rdfs:subPropertyOf ?superProperty . FILTER NOT EXISTS {?subProperty rdfs:subPropertyOf ?otherSuperProperty . ?otherSuperProperty rdfs:subPropertyOf ?superProperty . FILTER (?subProperty != ?otherSuperProperty && ?superProperty != ?otherSuperProperty)} FILTER (?subProperty != ?superProperty" + (named ? " && isIRI(?subProperty)" : "") + ") }";
    }

    private static final String SELECT_SUBPROPERTIES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?subProperty WHERE { ?subProperty rdfs:subPropertyOf ?superProperty . FILTER (?subProperty != ?superProperty" + (named ? "&& isIRI(?subProperty)" : "") + ") }";
    }

    private static final String SELECT_DIRECT_SUPERPROPERTIES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?superProperty WHERE { ?subProperty rdfs:subPropertyOf ?superProperty . FILTER NOT EXISTS {?subProperty rdfs:subPropertyOf ?otherSuperProperty . ?otherSuperProperty rdfs:subPropertyOf ?superProperty . FILTER (?subProperty != ?otherSuperProperty && ?superProperty != ?otherSuperProperty)} FILTER (?subProperty != ?superProperty" + (named ? " && isIRI(?subProperty)" : "") + ")}";
    }

    private static final String SELECT_SUPERPROPERTIES(boolean named) {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?superProperty WHERE { ?subProperty rdfs:subPropertyOf ?superProperty . FILTER (?subProperty != ?superProperty" + (named ? "&& isIRI(?subProperty)" : "") + ") }";
    }

    @Override
    public boolean isContainment() {
        if (this.getBehaviourDelegate() instanceof DatatypeProperty) {
            return false;
        }
        if (KOMMA.PROPERTY_CONTAINS.equals((Object)this.getURI())) {
            return true;
        }
        IQuery query = this.getEntityManager().createQuery(IS_CONTAINMENT);
        query.setParameter("property", (Object)this);
        return query.getBooleanResult();
    }

    protected IExtendedIterator<IProperty> getSubProperties(boolean direct, boolean includeInferred) {
        IQuery query = this.getEntityManager().createQuery(direct ? PropertySupport.SELECT_DIRECT_SUBPROPERTIES(true) : PropertySupport.SELECT_SUBPROPERTIES(true), includeInferred);
        query.setParameter("superProperty", (Object)this);
        return query.evaluate();
    }

    @Override
    public IExtendedIterator<IProperty> getDirectSuperProperties() {
        return this.getSuperProperties(true, true);
    }

    @Override
    public IExtendedIterator<IProperty> getDirectSubProperties() {
        return this.getSubProperties(true, false);
    }

    @Override
    public IExtendedIterator<IProperty> getSubProperties() {
        return this.getSubProperties(true, true);
    }

    @Override
    public IExtendedIterator<IProperty> getSuperProperties() {
        return this.getSuperProperties(true, true);
    }

    protected IExtendedIterator<IProperty> getSuperProperties(boolean direct, boolean includeInferred) {
        IQuery query = this.getEntityManager().createQuery(direct ? PropertySupport.SELECT_DIRECT_SUPERPROPERTIES(true) : PropertySupport.SELECT_SUPERPROPERTIES(true), includeInferred);
        query.setParameter("subProperty", (Object)this);
        return query.evaluate();
    }

    @Override
    public boolean isOrderedContainment() {
        if (this.getBehaviourDelegate() instanceof DatatypeProperty) {
            return false;
        }
        if (KOMMA.PROPERTY_ORDEREDCONTAINS.equals((Object)this.getURI())) {
            return true;
        }
        IQuery query = this.getEntityManager().createQuery(IS_ORDERED_CONTAINMENT);
        query.setParameter("property", (Object)this);
        return query.getBooleanResult();
    }

    @Override
    public boolean isDomainCompatible(Object object) {
        if (object instanceof IReference) {
            IQuery query = this.getEntityManager().createQuery(IS_DOMAIN_INSTANCE);
            query.setParameter("property", (Object)this);
            query.setParameter("object", object);
            return query.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean isRangeCompatible(IResource subject, Object object) {
        if (object instanceof IResource) {
            if (this.getEntityManager().getInferencing().doesOWL()) {
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?o a ?c { ?p rdfs:range ?c } UNION { ?c owl:onProperty ?p { ?restriction owl:allValuesFrom ?c } UNION { ?restriction owl:someValuesFrom ?c }}}";
                return ((IQuery)((IQuery)subject.getEntityManager().createQuery(query).setParameter("o", object)).setParameter("p", (Object)this)).getBooleanResult() || this.getRdfsRanges().isEmpty();
            }
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?r WHERE {?s a [ rdfs:subClassOf* ?restriction ] . ?restriction owl:onProperty [ rdfs:subPropertyOf* ?p ] . {{ ?restriction owl:allValuesFrom ?someClass } UNION { ?restriction owl:someValuesFrom ?someClass } FILTER NOT EXISTS { ?someClass owl:intersectionOf ?x }} .?r rdfs:subClassOf ?someClass}";
            IExtendedIterator it = ((IQuery)((IQuery)subject.getEntityManager().createQuery(query).setParameter("s", (Object)subject)).setParameter("p", (Object)this)).evaluate();
            if (it.hasNext()) {
                HashSet<IClass> rangeClasses = new HashSet<IClass>();
                HashSet<Class> seenClasses = new HashSet<Class>();
                LinkedList queue = new LinkedList(it.toSet());
                while (!queue.isEmpty()) {
                    Class clazz = (Class)queue.remove();
                    if (!seenClasses.add(clazz)) continue;
                    List unionOf = clazz.getOwlUnionOf();
                    if (unionOf == null) {
                        List intersectionOf = clazz.getOwlIntersectionOf();
                        if (intersectionOf != null || clazz.getURI() == null) continue;
                        rangeClasses.add((IClass)clazz);
                        continue;
                    }
                    queue.addAll(unionOf);
                }
                KommaUtil.removeSuperClasses(rangeClasses);
                for (IReference typeClass : new ArrayList(((IResource)object).getRdfTypes())) {
                    if (!rangeClasses.contains(typeClass)) continue;
                    return true;
                }
                return false;
            }
            it.close();
        }
        return this.isRangeCompatible(object);
    }

    @Override
    public boolean isRangeCompatible(Object object) {
        if (this.getBehaviourDelegate() instanceof DatatypeProperty) {
            return true;
        }
        if (object instanceof IReference) {
            IQuery query = this.getEntityManager().createQuery(IS_RANGE_INSTANCE);
            query.setParameter("property", (Object)this);
            query.setParameter("object", object);
            return query.getBooleanResult() || this.getRdfsRanges().isEmpty();
        }
        return false;
    }

    @Override
    public IExtendedIterator<? extends IClass> getNamedRanges(IEntity subject, boolean direct) {
        IExtendedIterator it = null;
        if (this.getEntityManager().getInferencing().doesOWL()) {
            String var = direct ? "r" : "resultR";
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?" + var + " WHERE {\t?o a ?restriction . ?restriction owl:onProperty ?p .\t{ ?restriction owl:allValuesFrom ?r } UNION { ?restriction owl:someValuesFrom ?r } .\tFILTER NOT EXISTS {\t\t?subP rdfs:subPropertyOf ?p .\t\t?otherRestriction owl:onProperty ?subP .\t\t?o a ?otherRestriction .\t\t{ ?otherRestriction owl:allValuesFrom ?otherR } .\t\t?otherR rdfs:subClassOf ?r . \t\tFILTER (isIRI(?otherR) && (?subP != ?p || ?otherR != ?r))\t}" + (direct ? "" : " ?resultR rdfs:subClassOf ?r . ") + "\tFILTER (isIRI(?" + var + ") && ?" + var + " != owl:Nothing)\tFILTER NOT EXISTS {\t\t?" + var + " komma:isAbstract ?abstract\t}}";
            it = ((IQuery)((IQuery)subject.getEntityManager().createQuery(query).setParameter("o", (Object)subject)).setParameter("p", (Object)this)).evaluate(IClass.class, new java.lang.Class[0]);
            if (it.hasNext()) {
                return it;
            }
        }
        if (it != null) {
            it.close();
        }
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?r WHERE {?o a ?c . ?c rdfs:subClassOf ?restriction . ?restriction owl:onProperty ?p . {{ ?restriction owl:allValuesFrom ?r } UNION { ?restriction owl:someValuesFrom ?r } FILTER NOT EXISTS { ?r owl:intersectionOf ?x } }}";
        it = ((IQuery)((IQuery)subject.getEntityManager().createQuery(query).setParameter("o", (Object)subject)).setParameter("p", (Object)this)).evaluate(IClass.class, new java.lang.Class[0]);
        if (it.hasNext()) {
            HashSet<IClass> namedRangeClasses = new HashSet<IClass>();
            HashSet<Class> seenClasses = new HashSet<Class>();
            LinkedList queue = new LinkedList(it.toSet());
            while (!queue.isEmpty()) {
                Class clazz = (Class)queue.remove();
                if (!seenClasses.add(clazz)) continue;
                List unionOf = clazz.getOwlUnionOf();
                if (unionOf == null) {
                    List intersectionOf = clazz.getOwlIntersectionOf();
                    if (intersectionOf != null || clazz.getURI() == null) continue;
                    namedRangeClasses.add((IClass)clazz);
                    continue;
                }
                queue.addAll(unionOf);
            }
            KommaUtil.removeSuperClasses(namedRangeClasses);
            if (!direct) {
                KommaUtil.unfoldSubClasses(namedRangeClasses);
            }
            return WrappedIterator.create(namedRangeClasses.iterator());
        }
        it.close();
        return this.getRanges(direct).filterDrop((Filter)new Filter<IClass>(){

            public boolean accept(IClass c) {
                return c.getURI() == null;
            }
        });
    }

    @Override
    public boolean hasListRange() {
        if (this.getBehaviourDelegate() instanceof DatatypeProperty) {
            return false;
        }
        IQuery query = this.getEntityManager().createQuery(HAS_LIST_RANGE_QUERY);
        query.setParameter("property", (Object)this);
        return query.getBooleanResult();
    }

    @Override
    public IExtendedIterator<? extends IClass> getRanges(boolean direct) {
        return ((IQuery)this.getEntityManager().createQuery(direct ? DIRECT_RANGE_QUERY : RANGE_QUERY).setParameter("property", (Object)this)).evaluate(IClass.class, new java.lang.Class[0]);
    }

    @Override
    public boolean isMany(IReference subject) {
        if (this.getBehaviourDelegate() instanceof FunctionalProperty) {
            return this.hasListRange();
        }
        if (subject != null && (Integer)((IResource)this.getEntityManager().find(subject)).getApplicableCardinality((IReference)this.getBehaviourDelegate()).getSecond() <= 1) {
            return this.hasListRange();
        }
        return true;
    }
}

