/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.apache.commons.codec.binary.Base64;

public class ByteArrayConverter
implements IConverter<byte[]> {
    @Inject
    private ILiteralFactory lf;

    public byte[] deserialize(String label) {
        return Base64.decodeBase64((byte[])label.getBytes());
    }

    public URI getDatatype() {
        return XMLSCHEMA.TYPE_BASE64BINARY;
    }

    public String getJavaClassName() {
        return byte[].class.getName();
    }

    public ILiteral serialize(byte[] data) {
        return this.lf.createLiteral(new String(Base64.encodeBase64((byte[])data)), this.getDatatype(), null);
    }

    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }
}

