/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.internal.AbstractEntityManager;
import net.enilink.komma.em.internal.behaviours.IEntityManagerAware;

public class DecoratingEntityManager
extends AbstractEntityManager {
    private CopyOnWriteArraySet<IEntityDecorator> decorators;
    @Inject
    IEntityManager sharedManager;

    @Inject
    public DecoratingEntityManager(Set<IEntityDecorator> decorators) {
        this.decorators = new CopyOnWriteArraySet<IEntityDecorator>(decorators);
    }

    public void addDecorator(IEntityDecorator decorator) {
        this.decorators.add(decorator);
    }

    @Override
    protected IEntity createBeanForClass(IReference resource, Class<?> type) {
        IEntity bean = super.createBeanForClass(resource, type);
        return this.decorate(bean);
    }

    public <T> T decorate(T entity) {
        if (entity instanceof IEntity) {
            ((IEntityManagerAware)entity).initEntityManager(this.sharedManager);
            for (IEntityDecorator decorator : this.decorators) {
                decorator.decorate((IEntity)entity);
            }
        }
        return entity;
    }

    public boolean hasDecorator(IEntityDecorator decorator) {
        return this.decorators.contains(decorator);
    }

    public void removeDecorator(IEntityDecorator decorator) {
        this.decorators.remove(decorator);
    }
}

