/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;

public class TypeManager {
    IDataManager dm;
    IReference[] readContexts;
    IReference[] modifyContexts;

    public TypeManager(IDataManager dm, IReference[] readContexts, IReference[] modifyContexts) {
        this.dm = dm;
        this.readContexts = readContexts;
        this.modifyContexts = modifyContexts;
    }

    public void addType(IReference resource, URI type) {
        if (!RDFS.TYPE_RESOURCE.equals((Object)type)) {
            this.dm.add((Iterable)new Statement(resource, (IReference)RDF.PROPERTY_TYPE, (Object)type), this.modifyContexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<URI> getTypes(IReference res) {
        try (IExtendedIterator match = this.dm.match(res, (IReference)RDF.PROPERTY_TYPE, null, true, this.readContexts);){
            if (!match.hasNext()) {
                Set<URI> set = Collections.emptySet();
                return set;
            }
            Object obj = ((IStatement)match.next()).getObject();
            if (obj instanceof IReference && ((IReference)obj).getURI() != null && !match.hasNext()) {
                Set<URI> set = Collections.singleton(((IReference)obj).getURI());
                return set;
            }
            ArrayList<URI> types = new ArrayList<URI>();
            if (obj instanceof IReference && ((IReference)obj).getURI() != null) {
                types.add(((IReference)obj).getURI());
            }
            while (match.hasNext()) {
                obj = ((IStatement)match.next()).getObject();
                if (!(obj instanceof IReference) || ((IReference)obj).getURI() == null) continue;
                types.add(((IReference)obj).getURI());
            }
            ArrayList<URI> arrayList = types;
            return arrayList;
        }
    }

    public void removeType(IReference resource, URI type) {
        this.dm.remove((Iterable)new Statement(resource, (IReference)RDF.PROPERTY_TYPE, (Object)type), this.modifyContexts);
    }
}

