/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.behaviours;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.vocab.komma.KOMMA;

public abstract class AbstractRDFMap
extends AbstractMap<Object, Object>
implements Map<Object, Object>,
Refreshable,
Mergeable,
IEntity,
Behaviour<IEntity> {
    private int _size = 0;
    private transient Set<Map.Entry<Object, Object>> entrySet;
    IEntityManager manager;
    volatile transient int modCount;
    final String SELECT_ENTRY_BY_KEY = "PREFIX komma:<http://enilink.net/vocab/komma#> SELECT DISTINCT ?entry where {?resource komma:" + KOMMA.PROPERTY_ENTRY.localPart() + " ?entry . ?entry komma:" + this.getUri4Key().localPart() + " ?key}";

    void addStatement(IReference subj, URI pred, Object obj) {
        if (obj == null) {
            return;
        }
        this.getEntityManager().add((Iterable)new Statement(subj, (IReference)pred, obj));
    }

    @Override
    public void clear() {
        IExtendedIterator<IValue> values = this.match((IReference)this.getBehaviourDelegate(), KOMMA.PROPERTY_ENTRY, null);
        while (values.hasNext()) {
            this.removeEntry((IReference)values.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getEntry(key) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry createMapEntry(IValue v) {
        IValue value;
        try (IExtendedIterator<IValue> it = null;){
            it = this.match((IReference)v, this.getUri4Value(), null);
            value = (IValue)it.next();
        }
        it = this.match((IReference)v, this.getUri4Key(), null);
        IValue key = (IValue)it.next();
        Entry entry = new Entry(this.getEntityManager().toInstance(key), this.getEntityManager().toInstance(value));
        return entry;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        IReference entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        try (IExtendedIterator<IValue> values = this.match(entry, this.getUri4Value(), null);){
            if (values.hasNext()) {
                Object object = this.getEntityManager().toInstance((IValue)values.next());
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReference getEntry(Object key) {
        try (IExtendedIterator result = null;){
            result = ((IQuery)((IQuery)this.getEntityManager().createQuery(this.SELECT_ENTRY_BY_KEY).setParameter("resource", this.getBehaviourDelegate())).setParameter("key", key)).evaluateRestricted(IReference.class, new Class[0]);
            if (result.hasNext()) {
                IReference iReference = (IReference)result.next();
                return iReference;
            }
        }
        return null;
    }

    private Entry getEntryAsRDF4JMapEntry(Object key) throws Exception {
        return this.createMapEntry((IValue)this.getEntry(key));
    }

    protected abstract URI getUri4Key();

    protected abstract URI getUri4Value();

    @Override
    public Set<Object> keySet() {
        return super.keySet();
    }

    private IExtendedIterator<IValue> match(IReference subj, URI pred, IValue obj) {
        return new ConvertingIterator<IStatement, IValue>((Iterator)this.getEntityManager().match(subj, (IReference)pred, (Object)obj)){

            protected IValue convert(IStatement stmt) {
                return (IValue)stmt.getObject();
            }
        };
    }

    public void merge(Object source) {
        if (source instanceof Map) {
            this.clear();
            this.putAll((Map)source);
        }
    }

    @Override
    public Object put(Object key, Object value) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.get(key);
            this.remove(key);
        }
        IEntity mapEntry = this.manager.create(new IReference[]{this.manager.find((IReference)KOMMA.TYPE_MAPENTRY)});
        this.addStatement((IReference)this, KOMMA.PROPERTY_ENTRY, mapEntry);
        this.addStatement((IReference)mapEntry, this.getUri4Key(), key);
        this.addStatement((IReference)this.getBehaviourDelegate(), this.getUri4Value(), value);
        ++this._size;
        ++this.modCount;
        return result;
    }

    public void refresh() {
        this._size = 0;
    }

    @Override
    public Object remove(Object key) {
        Object result = this.get(key);
        if (result != null) {
            IReference entry = this.getEntry(key);
            this.removeEntry(entry);
        }
        return result;
    }

    private void removeEntry(IReference entry) {
        this.removeStatements((IReference)this.getBehaviourDelegate(), KOMMA.PROPERTY_ENTRY, (IValue)entry);
        this.removeStatements(entry, this.getUri4Key(), null);
        this.removeStatements(entry, this.getUri4Value(), null);
        --this._size;
    }

    void removeStatements(IReference subj, URI pred, IValue obj) {
        this.getEntityManager().remove((Iterable)new Statement(subj, (IReference)pred, (Object)obj));
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private class SimpleRDF4JMapIterator
    implements Iterator<Map.Entry<Object, Object>> {
        private Stack<Entry> elements = new Stack();

        public SimpleRDF4JMapIterator() {
            IExtendedIterator values = AbstractRDFMap.this.match((IReference)AbstractRDFMap.this.getBehaviourDelegate(), KOMMA.PROPERTY_ENTRY, null);
            while (values.hasNext()) {
                this.elements.push(AbstractRDFMap.this.createMapEntry((IValue)values.next()));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.elements.empty();
        }

        @Override
        public Entry next() {
            return this.elements.pop();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            Entry candidate;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            try {
                candidate = AbstractRDFMap.this.getEntryAsRDF4JMapEntry(e.getKey());
            }
            catch (Exception e1) {
                return false;
            }
            return candidate != null && candidate.equals(e);
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new SimpleRDF4JMapIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    private class Entry
    implements Map.Entry<Object, Object> {
        private Object key;
        private Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry candidate = (Map.Entry)obj;
            return this.key.equals(candidate.getKey()) && this.value.equals(candidate.getValue());
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

