/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.behaviours;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.commons.util.IPartialOrderProvider;
import net.enilink.commons.util.LinearExtension;
import net.enilink.composition.properties.komma.KommaPropertySet;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.vocab.komma.KOMMA;

public class OrderedPropertySet<E>
extends KommaPropertySet<E>
implements List<E>,
RandomAccess,
Cloneable,
Refreshable {
    private List<E> internalList = new AbstractList<E>(){

        @Override
        public void add(int index, E element) {
            OrderedPropertySet.this.ensureCache().add(index, element);
            Object succElement = null;
            if (index < OrderedPropertySet.this.getCache().size() - 1) {
                succElement = OrderedPropertySet.this.getCache().get(index + 1);
            }
            Object predElement = null;
            if (index > 0) {
                predElement = OrderedPropertySet.this.getCache().get(index - 1);
            }
            if (succElement != null) {
                OrderedPropertySet.this.getPrecedes(element).add(succElement);
            }
            if (predElement != null) {
                if (succElement != null) {
                    OrderedPropertySet.this.getPrecedes(predElement).remove(succElement);
                }
                OrderedPropertySet.this.getPrecedes(predElement).add(element);
            }
            OrderedPropertySet.super.add(element);
        }

        @Override
        public E get(int index) {
            return OrderedPropertySet.this.ensureCache().get(index);
        }

        @Override
        public int indexOf(Object o) {
            return OrderedPropertySet.this.ensureCache().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return OrderedPropertySet.this.ensureCache().lastIndexOf(o);
        }

        @Override
        public E remove(int index) {
            Object removed = OrderedPropertySet.this.ensureCache().remove(index);
            if (removed != null) {
                Object succElement = null;
                if (index < OrderedPropertySet.this.getCache().size()) {
                    succElement = OrderedPropertySet.this.getCache().get(index);
                }
                Object predElement = null;
                if (index > 0) {
                    predElement = OrderedPropertySet.this.getCache().get(index - 1);
                }
                if (succElement != null) {
                    OrderedPropertySet.this.getPrecedes(removed).remove(succElement);
                }
                if (predElement != null) {
                    if (succElement != null) {
                        OrderedPropertySet.this.getPrecedes(predElement).add(succElement);
                    }
                    OrderedPropertySet.this.getPrecedes(predElement).remove(removed);
                }
                OrderedPropertySet.super.remove(removed);
            }
            return removed;
        }

        @Override
        public E set(int index, E element) {
            Object predElement;
            Object succElement;
            Object oldElement = OrderedPropertySet.this.ensureCache().set(index, element);
            if (index < OrderedPropertySet.this.getCache().size() - 1 && (succElement = OrderedPropertySet.this.getCache().get(index + 1)) != null) {
                if (oldElement != null) {
                    OrderedPropertySet.this.getPrecedes(oldElement).remove(succElement);
                }
                OrderedPropertySet.this.getPrecedes(element).add(succElement);
            }
            if (index > 0 && (predElement = OrderedPropertySet.this.getCache().get(index - 1)) != null) {
                if (oldElement != null) {
                    OrderedPropertySet.this.getPrecedes(predElement).remove(oldElement);
                }
                OrderedPropertySet.this.getPrecedes(predElement).add(element);
            }
            OrderedPropertySet.super.add(element);
            return oldElement;
        }

        @Override
        public int size() {
            return OrderedPropertySet.super.size();
        }
    };

    public OrderedPropertySet(IReference subject, IReference property) {
        super(subject, property);
    }

    @Override
    public boolean add(E o) {
        this.add(this.ensureCache().size(), o);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.internalList.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.internalList.addAll(index, c);
    }

    protected IExtendedIterator<E> createElementsIterator() {
        class ElementsIterator
        extends WrappedIterator<E> {
            E current;
            int index;
            List<E> list;

            protected ElementsIterator(List<E> list) {
                super(list.iterator());
                this.index = -1;
            }

            public E next() {
                ++this.index;
                this.current = this.base.next();
                return this.current;
            }

            public void remove() {
                Object succElement;
                this.base.remove();
                if (this.current != null && this.index < this.list.size() && (succElement = this.list.get(this.index)) != null) {
                    OrderedPropertySet.this.getPrecedes(this.current).remove(succElement);
                }
                this.current = null;
            }
        }
        return new ElementsIterator(this.ensureCache());
    }

    private final List<E> ensureCache() {
        List list = this.getCache();
        if (list == null) {
            final List values = super.createElementsIterator().toList();
            list = new LinearExtension(new IPartialOrderProvider<E>(){

                public Collection<E> getElements() {
                    return values;
                }

                public Collection<E> getSuccessors(E element) {
                    return OrderedPropertySet.this.getPrecedes(element);
                }
            }).createLinearExtension(new ArrayList());
            this.setCache(list);
        }
        return list;
    }

    @Override
    public E get(int index) {
        return this.internalList.get(index);
    }

    protected int getCacheLimit() {
        return Integer.MAX_VALUE;
    }

    private Collection<E> getPrecedes(E element) {
        return (Collection)((IResource)element).get((IReference)KOMMA.PROPERTY_PRECEDES);
    }

    @Override
    public int indexOf(Object o) {
        return this.internalList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.internalList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.internalList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.internalList.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.internalList.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.ensureCache().indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        return this.internalList.set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.internalList.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.internalList.spliterator();
    }
}

