/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.Iterator;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.komma.core.IGraphResult;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.Statement;
import net.enilink.komma.em.internal.IEntityManagerInternal;

public class GraphIterator
extends ConvertingIterator<IStatement, IStatement>
implements IGraphResult {
    private IEntityManagerInternal manager;
    private int maxResults;
    private int position;
    private boolean resolve;

    public GraphIterator(IEntityManagerInternal manager, IGraphResult result, int maxResults, boolean resolve) {
        super((Iterator)result);
        this.manager = manager;
        this.maxResults = maxResults;
        this.resolve = resolve;
    }

    protected IStatement convert(IStatement stmt) {
        if (this.resolve) {
            return new Statement((IReference)this.manager.find(stmt.getSubject()), (IReference)this.manager.find(stmt.getPredicate()), this.manager.toInstance((IValue)stmt.getObject(), null, null));
        }
        return stmt;
    }

    public boolean hasNext() {
        if (this.maxResults > 0 && this.position >= this.maxResults) {
            this.close();
            return false;
        }
        return super.hasNext();
    }

    public IStatement next() {
        try {
            ++this.position;
            IStatement iStatement = (IStatement)super.next();
            return iStatement;
        }
        finally {
            if (this.maxResults > 0 && this.position >= this.maxResults) {
                this.close();
            }
        }
    }
}

