/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.internal.query;

import java.util.Iterator;
import java.util.List;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.ITupleResult;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.URI;
import net.enilink.komma.em.internal.IEntityManagerInternal;
import net.enilink.komma.em.internal.query.ResultInfo;

public class ProjectedTupleIterator
extends ConvertingIterator<IBindings<IValue>, Object>
implements ITupleResult<Object> {
    private IEntityManagerInternal manager;
    private int maxResults;
    private int position;
    private ITupleResult<IBindings<IValue>> result;
    private ResultInfo resultInfo;

    public ProjectedTupleIterator(IEntityManagerInternal manager, ITupleResult<IBindings<IValue>> result, int maxResults, ResultInfo resultInfo) {
        super(result);
        this.result = result;
        this.manager = manager;
        this.maxResults = maxResults;
        this.resultInfo = resultInfo;
    }

    protected Object convert(IBindings<IValue> solution) {
        IValue value;
        Iterator it = solution.iterator();
        IValue iValue = value = it.hasNext() ? (IValue)it.next() : null;
        if (value == null) {
            return null;
        }
        if (this.resultInfo != null) {
            if (value instanceof IReference) {
                if (!this.resultInfo.types.isEmpty() && this.resultInfo.types.get(0) == URI.class) {
                    return ((IReference)value).getURI();
                }
                if (this.resultInfo.typeRestricted) {
                    return this.manager.findRestricted((IReference)value, this.resultInfo.types);
                }
                return this.manager.find((IReference)value, this.resultInfo.types);
            }
            return this.manager.toInstance(value, this.resultInfo.types.get(0), null);
        }
        return this.manager.toInstance(value, null, null);
    }

    public List<String> getBindingNames() {
        return this.result.getBindingNames();
    }

    public boolean hasNext() {
        if (this.maxResults > 0 && this.position >= this.maxResults) {
            this.close();
            return false;
        }
        return super.hasNext();
    }

    public Object next() {
        try {
            ++this.position;
            Object object = super.next();
            return object;
        }
        finally {
            if (this.maxResults > 0 && this.position >= this.maxResults) {
                this.close();
            }
        }
    }
}

