/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.results;

import java.util.HashMap;
import java.util.Map;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IResultDescriptor;
import net.enilink.komma.em.internal.query.QueryBase;
import net.enilink.komma.query.SparqlBuilder;

public class ResultDescriptor<R>
extends QueryBase<IResultDescriptor<R>>
implements IResultDescriptor<R> {
    protected boolean includeInferred;
    protected Map<String, Object> parameters;
    protected IExtendedIterator<R> results;
    protected String property;
    protected String parameterVariable;
    protected String resultVariable;
    protected String sparql;
    protected SparqlBuilder sparqlBuilder;

    public ResultDescriptor(String sparql) {
        this.sparql = sparql;
    }

    public ResultDescriptor(String sparql, String property, String resultVariable, String parameterVariable) {
        this.sparql = sparql;
        this.property = property;
        this.resultVariable = resultVariable;
        this.parameterVariable = parameterVariable;
    }

    public <T> IResultDescriptor<T> bindResultType(Class<T> resultType, Class<?> ... resultTypes) {
        return (IResultDescriptor)super.doBindResultType(resultType, resultTypes);
    }

    public IExtendedIterator<R> evaluate(IEntityManager manager) {
        if (this.results == null) {
            String sparql = this.toQueryString();
            IQuery query = manager.createQuery(sparql, this.getIncludeInferred());
            ((QueryBase)query).initializeFrom(this);
            if (this.parameters != null) {
                for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            this.results = query.evaluate();
        }
        return this.results;
    }

    public boolean getIncludeInferred() {
        return this.includeInferred;
    }

    public String getParameterVariable() {
        return this.parameterVariable;
    }

    public String getProperty() {
        return this.property;
    }

    public String getResultVariable() {
        return this.resultVariable;
    }

    public String toQueryString() {
        if (this.sparqlBuilder != null) {
            return this.sparqlBuilder.toString();
        }
        return this.sparql;
    }

    protected SparqlBuilder getSparqlBuilder() {
        if (this.sparqlBuilder == null) {
            this.sparqlBuilder = new SparqlBuilder(this.sparql);
        }
        return this.sparqlBuilder;
    }

    public IResultDescriptor<R> prefetch(IResultDescriptor<?> descriptor) {
        if (descriptor.getProperty() == null) {
            throw new IllegalArgumentException("Iterator has an invalid property.");
        }
        return this.prefetch(descriptor.getProperty(), descriptor);
    }

    public IResultDescriptor<R> prefetch(String property, IResultDescriptor<?> descriptor) {
        if (descriptor instanceof ResultDescriptor && ((ResultDescriptor)descriptor).sparqlBuilder != null) {
            this.getSparqlBuilder().optional(property, descriptor.getResultVariable(), descriptor.getParameterVariable(), ((ResultDescriptor)descriptor).sparqlBuilder);
        } else {
            this.getSparqlBuilder().optional(property, descriptor.getResultVariable(), descriptor.getParameterVariable(), descriptor.toQueryString());
        }
        return this;
    }

    public IResultDescriptor<R> prefetchTypes() {
        this.getSparqlBuilder().fetchTypes();
        return this;
    }

    public <T> IResultDescriptor<T> restrictResultType(Class<T> resultType, Class<?> ... resultTypes) {
        return (IResultDescriptor)super.doRestrictResultType(resultType, resultTypes);
    }

    @Override
    public IResultDescriptor<R> setFirstResult(int startPosition) {
        return (IResultDescriptor)super.setFirstResult(startPosition);
    }

    public IResultDescriptor<R> setIncludeInferred(boolean include) {
        this.includeInferred = include;
        return this;
    }

    public IResultDescriptor<R> setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(name, value);
        return this;
    }
}

