/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.em.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.komma.core.IUnitOfWork;

public class UnitOfWork
implements IUnitOfWork {
    private ThreadLocal<Integer> countLocal = new ThreadLocal();
    private ThreadLocal<List<AutoCloseable>> trackedCloseablesLocal = new ThreadLocal();
    private Set<Thread> clientThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean debug;

    public UnitOfWork() {
        this(false);
    }

    public UnitOfWork(boolean debug) {
        this.debug = debug;
    }

    public void addCloseable(AutoCloseable closeable) {
        List<AutoCloseable> trackedCloseables = this.trackedCloseablesLocal.get();
        if (trackedCloseables == null) {
            trackedCloseables = new ArrayList<AutoCloseable>();
            this.trackedCloseablesLocal.set(trackedCloseables);
        }
        trackedCloseables.add(closeable);
    }

    public void begin() {
        Integer count = this.countLocal.get();
        this.countLocal.set(count == null ? 1 : count + 1);
        if (this.debug) {
            this.clientThreads.add(Thread.currentThread());
        }
    }

    public void end() {
        Integer count = this.countLocal.get();
        if (count == null) {
            return;
        }
        int newCount = count - 1;
        this.countLocal.set(newCount);
        if (newCount <= 0) {
            List<AutoCloseable> trackedCloseables = this.trackedCloseablesLocal.get();
            if (trackedCloseables != null) {
                for (AutoCloseable closeable : trackedCloseables) {
                    try {
                        closeable.close();
                    }
                    catch (Exception exception) {}
                }
                trackedCloseables.clear();
            }
            this.trackedCloseablesLocal.remove();
            this.countLocal.remove();
            if (this.debug) {
                this.clientThreads.remove(Thread.currentThread());
            }
        }
    }

    public boolean isActive() {
        return this.countLocal.get() != null;
    }

    public Collection<Thread> getClientThreads() {
        return Collections.unmodifiableCollection(this.clientThreads);
    }
}

