/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.enilink.komma.parser.sparql.tree.BNode;
import net.enilink.komma.parser.sparql.tree.BooleanLiteral;
import net.enilink.komma.parser.sparql.tree.DoubleLiteral;
import net.enilink.komma.parser.sparql.tree.GenericLiteral;
import net.enilink.komma.parser.sparql.tree.GraphNode;
import net.enilink.komma.parser.sparql.tree.IntegerLiteral;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.QName;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.SuppressNode;

public abstract class BaseRdfParser
extends BaseParser<Object> {
    public static Object LIST_BEGIN = new Object();

    public GenericLiteral createLiteral(String label, String language) {
        return new GenericLiteral(label.trim(), null, language != null ? language.trim() : null);
    }

    public GenericLiteral createTypedLiteral(String label, GraphNode datatype) {
        return new GenericLiteral(label.trim(), datatype, null);
    }

    public Rule RdfLiteral() {
        return this.Sequence(this.StringLiteral(), this.push(null), new Object[]{this.Optional(this.FirstOf(this.LANGTAG(), this.Sequence(this.String("^^"), this.IriRef(), new Object[0]), new Object[0]), this.drop(1), new Object[0]), this.push(this.peek() instanceof GraphNode ? this.createTypedLiteral((String)this.pop(1), (GraphNode)this.pop()) : this.createLiteral((String)this.pop(1), (String)this.pop())), this.WS()});
    }

    public Rule NumericLiteral() {
        return this.FirstOf(this.NumericLiteralUnsigned(), this.NumericLiteralPositive(), new Object[]{this.NumericLiteralNegative()});
    }

    public Rule NumericLiteralUnsigned() {
        return this.FirstOf(this.DOUBLE(), this.DECIMAL(), new Object[]{this.INTEGER()});
    }

    public Rule NumericLiteralPositive() {
        return this.FirstOf(this.DOUBLE_POSITIVE(), this.DECIMAL_POSITIVE(), new Object[]{this.INTEGER_POSITIVE()});
    }

    public Rule NumericLiteralNegative() {
        return this.FirstOf(this.DOUBLE_NEGATIVE(), this.DECIMAL_NEGATIVE(), new Object[]{this.INTEGER_NEGATIVE()});
    }

    public Rule BooleanLiteral() {
        return this.Sequence(this.FirstOf("TRUE", "FALSE", new Object[0]), this.push(new BooleanLiteral("true".equals(this.match().toLowerCase()))), new Object[0]);
    }

    public Rule StringLiteral() {
        return this.FirstOf(this.STRING_LITERAL_LONG1(), this.STRING_LITERAL1(), new Object[]{this.STRING_LITERAL_LONG2(), this.STRING_LITERAL2()});
    }

    public Rule IriRef() {
        return this.FirstOf(this.IRI_REF(), this.PrefixedName(), new Object[0]);
    }

    public String stripColon(String prefix) {
        return prefix.trim().replaceAll(":", "");
    }

    public String trim(String string) {
        return string != null ? string.trim() : null;
    }

    public Rule PrefixedName() {
        return this.FirstOf(this.PNAME_LN(), this.Sequence(this.PNAME_NS(), this.WS(), new Object[]{this.push(new QName((String)this.pop(), ""))}), new Object[0]);
    }

    public Rule BlankNode() {
        return this.Sequence(this.FirstOf(this.BLANK_NODE_LABEL(), this.Sequence(Character.valueOf('['), Character.valueOf(']'), new Object[]{this.push(null)}), new Object[0]), this.push(new BNode((String)this.pop())), new Object[0]);
    }

    @SuppressNode
    public Rule WS() {
        return this.ZeroOrMore(this.FirstOf(this.COMMENT(), this.WS_NO_COMMENT(), new Object[0]));
    }

    public Rule WS_NO_COMMENT() {
        return this.FirstOf(this.Ch(' '), this.Ch('\t'), new Object[]{this.Ch('\f'), this.EOL()});
    }

    public Rule PNAME_NS() {
        return this.Sequence(this.Optional(this.PN_PREFIX()), this.push(this.match()), new Object[]{this.Ch(':')});
    }

    public Rule PNAME_LN() {
        return this.Sequence(this.PNAME_NS(), this.PN_LOCAL(), new Object[]{this.push(new QName((String)this.pop(1), ((String)this.pop()).trim()))});
    }

    public Rule IRI_REF() {
        return this.Sequence(this.LESS_NO_COMMENT(), this.ZeroOrMore(this.TestNot(this.FirstOf(this.IRI_REF_CHARS_WO_SPACE(), this.Ch(' '), new Object[0])), ANY, new Object[0]), new Object[]{this.push(new IriRef(this.match().trim())), Character.valueOf('>')});
    }

    public Rule IRI_REF_WSPACE() {
        return this.Sequence(this.LESS_NO_COMMENT(), this.ZeroOrMore(this.TestNot(this.IRI_REF_CHARS_WO_SPACE()), ANY, new Object[0]), new Object[]{this.push(new IriRef(this.match().trim())), Character.valueOf('>')});
    }

    public Rule IRI_REF_CHARS_WO_SPACE() {
        return this.FirstOf(this.LESS_NO_COMMENT(), this.Ch('>'), new Object[]{this.Ch('\"'), this.Ch('{'), this.Ch('}'), this.Ch('|'), this.Ch('^'), this.Ch('\\'), this.Ch('`'), this.CharRange('\u0000', '\u0019')});
    }

    public Rule BLANK_NODE_LABEL() {
        return this.Sequence(this.String("_:"), this.PN_LOCAL(), new Object[]{this.WS()});
    }

    public Rule LANGTAG() {
        return this.Sequence(this.Ch('@'), this.Sequence(this.OneOrMore(this.PN_CHARS_BASE()), this.ZeroOrMore(Character.valueOf('-'), this.OneOrMore(this.PN_CHARS_BASE(), this.DIGIT(), new Object[0]), new Object[0]), new Object[0]), new Object[]{this.push(this.match())});
    }

    public Rule INTEGER() {
        return this.Sequence(this.OneOrMore(this.DIGIT()), this.push(new IntegerLiteral(Integer.parseInt(this.match().trim()))), new Object[]{this.WS()});
    }

    public Rule DECIMAL() {
        return this.Sequence(this.FirstOf(this.Sequence(this.OneOrMore(this.DIGIT()), Character.valueOf('.'), new Object[]{this.ZeroOrMore(this.DIGIT())}), this.Sequence(Character.valueOf('.'), this.OneOrMore(this.DIGIT()), new Object[0]), new Object[0]), this.push(new DoubleLiteral(Double.parseDouble(this.match().trim()))), new Object[]{this.WS()});
    }

    public Rule DOUBLE() {
        return this.Sequence(this.FirstOf(this.Sequence(this.OneOrMore(this.DIGIT()), Character.valueOf('.'), new Object[]{this.ZeroOrMore(this.DIGIT()), this.EXPONENT()}), this.Sequence(Character.valueOf('.'), this.OneOrMore(this.DIGIT()), new Object[]{this.EXPONENT()}), new Object[]{this.Sequence(this.OneOrMore(this.DIGIT()), this.EXPONENT(), new Object[0])}), this.push(new DoubleLiteral(Double.parseDouble(this.match().trim()))), new Object[]{this.WS()});
    }

    public Rule INTEGER_POSITIVE() {
        return this.Sequence(Character.valueOf('+'), this.INTEGER(), new Object[0]);
    }

    public Rule DECIMAL_POSITIVE() {
        return this.Sequence(Character.valueOf('+'), this.DECIMAL(), new Object[0]);
    }

    public Rule DOUBLE_POSITIVE() {
        return this.Sequence(Character.valueOf('+'), this.DOUBLE(), new Object[0]);
    }

    public Rule INTEGER_NEGATIVE() {
        return this.Sequence(Character.valueOf('-'), this.INTEGER(), new Object[]{this.push(new IntegerLiteral(-((IntegerLiteral)this.pop()).getValue()))});
    }

    public Rule DECIMAL_NEGATIVE() {
        return this.Sequence(Character.valueOf('-'), this.DECIMAL(), new Object[]{this.push(new DoubleLiteral(-((DoubleLiteral)this.pop()).getValue()))});
    }

    public Rule DOUBLE_NEGATIVE() {
        return this.Sequence(Character.valueOf('-'), this.DOUBLE(), new Object[]{this.push(new DoubleLiteral(-((DoubleLiteral)this.pop()).getValue()))});
    }

    public Rule EXPONENT() {
        return this.Sequence(this.IgnoreCase('e'), this.Optional(this.FirstOf(Character.valueOf('+'), Character.valueOf('-'), new Object[0])), new Object[]{this.OneOrMore(this.DIGIT())});
    }

    public Rule STRING_LITERAL1() {
        return this.Sequence(this.Ch('\''), this.push(new StringBuilder()), new Object[]{this.ZeroOrMore(this.FirstOf(this.Sequence(this.TestNot(this.FirstOf(Character.valueOf('\''), Character.valueOf('\\'), new Object[]{Character.valueOf('\n'), Character.valueOf('\r')})), ANY, new Object[]{this.appendToSb(this.matchedChar())}), this.ECHAR(), new Object[]{this.UCHAR()})), this.push(this.pop().toString()), Character.valueOf('\''), this.WS()});
    }

    public Rule STRING_LITERAL2() {
        return this.Sequence(this.Ch('\"'), this.push(new StringBuilder()), new Object[]{this.ZeroOrMore(this.FirstOf(this.Sequence(this.TestNot(this.FirstOf(Character.valueOf('\"'), Character.valueOf('\\'), new Object[]{Character.valueOf('\n'), Character.valueOf('\r')})), ANY, new Object[]{this.appendToSb(this.matchedChar())}), this.ECHAR(), new Object[]{this.UCHAR()})), this.push(this.pop().toString()), Character.valueOf('\"'), this.WS()});
    }

    public Rule STRING_LITERAL_LONG1() {
        return this.Sequence(this.String("'''"), this.push(new StringBuilder()), new Object[]{this.ZeroOrMore(this.TestNot("'''"), this.Optional(this.FirstOf("''", Character.valueOf('\''), new Object[0]), this.appendToSb(this.match()), new Object[0]), new Object[]{this.FirstOf(this.Sequence(this.TestNot(this.FirstOf(Character.valueOf('\''), Character.valueOf('\\'), new Object[0])), ANY, new Object[]{this.appendToSb(this.matchedChar())}), this.ECHAR(), new Object[]{this.UCHAR()})}), this.push(this.pop().toString()), "'''", this.WS()});
    }

    public Rule STRING_LITERAL_LONG2() {
        return this.Sequence("\"\"\"", this.push(new StringBuilder()), new Object[]{this.ZeroOrMore(this.TestNot("\"\"\""), this.Optional(this.FirstOf("\"\"", Character.valueOf('\"'), new Object[0]), this.appendToSb(this.match()), new Object[0]), new Object[]{this.FirstOf(this.Sequence(this.TestNot(this.FirstOf(Character.valueOf('\"'), Character.valueOf('\\'), new Object[0])), ANY, new Object[]{this.appendToSb(this.matchedChar())}), this.ECHAR(), new Object[]{this.UCHAR()})}), this.push(this.pop().toString()), "\"\"\"", this.WS()});
    }

    public boolean appendToSb(String s) {
        ((StringBuilder)this.peek()).append(s);
        return true;
    }

    public boolean appendToSb(char c) {
        ((StringBuilder)this.peek()).append(c);
        return true;
    }

    public char unescape(char c) {
        switch (c) {
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c;
    }

    public Rule Ech(char c) {
        return this.Sequence(this.Ch(c), this.appendToSb(this.unescape(c)), new Object[0]);
    }

    public Rule ECHAR() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.Ech('t'), this.Ech('b'), new Object[]{this.Ech('n'), this.Ech('r'), this.Ech('f'), this.Ech('\"'), this.Ech('\''), this.Ech('\\')}), new Object[0]);
    }

    public Rule UCHAR() {
        return this.FirstOf(this.Sequence("\\u", this.Sequence(this.HEX(), this.HEX(), new Object[]{this.HEX(), this.HEX()}), new Object[]{this.appendToSb(new String(Character.toChars(Integer.parseInt(this.match(), 16))))}), this.Sequence("\\U", this.Sequence(this.HEX(), this.HEX(), new Object[]{this.HEX(), this.HEX(), this.HEX(), this.HEX(), this.HEX(), this.HEX()}), new Object[]{this.appendToSb(new String(Character.toChars(Integer.parseInt(this.match(), 16))))}), new Object[0]);
    }

    public Rule PN_CHARS_U() {
        return this.FirstOf(this.PN_CHARS_BASE(), this.Ch('_'), new Object[0]);
    }

    public Rule PN_CHARS() {
        return this.FirstOf(this.PN_CHARS_U(), Character.valueOf('-'), new Object[]{this.DIGIT(), this.Ch('\u00b7'), this.CharRange('\u0300', '\u036f'), this.CharRange('\u203f', '\u2040')});
    }

    public Rule PN_PREFIX() {
        return this.Sequence(this.PN_CHARS_BASE(), this.ZeroOrMore(this.FirstOf(this.PN_CHARS(), this.Sequence(Character.valueOf('.'), this.PN_CHARS(), new Object[0]), new Object[0])), new Object[0]);
    }

    public Rule PN_CHARS_SUFFIX() {
        return this.FirstOf(this.PN_CHARS(), this.Ch(':'), new Object[]{this.PLX()});
    }

    public Rule PN_LOCAL() {
        return this.Sequence(this.Sequence(this.FirstOf(this.PN_CHARS_U(), this.Ch(':'), new Object[]{this.DIGIT(), this.PLX()}), this.ZeroOrMore(this.FirstOf(this.PN_CHARS_SUFFIX(), this.Sequence(this.Ch('.'), this.PN_CHARS_SUFFIX(), new Object[0]), new Object[0])), new Object[0]), this.push(this.match()), new Object[]{this.WS()});
    }

    public Rule PLX() {
        return this.FirstOf(this.PERCENT(), this.PN_LOCAL_ESC(), new Object[0]);
    }

    public Rule PERCENT() {
        return this.Sequence(this.Ch('%'), this.HEX(), new Object[]{this.HEX()});
    }

    public Rule HEX() {
        return this.FirstOf(this.DIGIT(), this.CharRange('A', 'F'), new Object[]{this.CharRange('a', 'f')});
    }

    public Rule PN_LOCAL_ESC() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(Character.valueOf('_'), Character.valueOf('~'), new Object[]{Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('$'), Character.valueOf('&'), "'", Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('@'), Character.valueOf('%')}), new Object[0]);
    }

    public Rule PN_CHARS_BASE() {
        return this.FirstOf(this.CharRange('A', 'Z'), this.CharRange('a', 'z'), new Object[]{this.CharRange('\u00c0', '\u00d6'), this.CharRange('\u00d8', '\u00f6'), this.CharRange('\u00f8', '\u02ff'), this.CharRange('\u0370', '\u037d'), this.CharRange('\u037f', '\u1fff'), this.CharRange('\u200c', '\u200d'), this.CharRange('\u2070', '\u218f'), this.CharRange('\u2c00', '\u2fef'), this.CharRange('\u3001', '\ud7ff'), this.CharRange('\uf900', '\ufdcf'), this.CharRange('\ufdf0', '\ufffd')});
    }

    public Rule DIGIT() {
        return this.CharRange('0', '9');
    }

    public Rule COMMENT() {
        return this.Sequence(this.Ch('#'), this.ZeroOrMore(this.TestNot(this.EOL()), ANY, new Object[0]), new Object[]{this.EOL()});
    }

    public Rule EOL() {
        return this.FirstOf(this.Ch('\n'), this.Ch('\r'), new Object[0]);
    }

    public Rule LESS_NO_COMMENT() {
        return this.Sequence(this.Ch('<'), this.ZeroOrMore(this.WS_NO_COMMENT()), new Object[0]);
    }

    protected Rule fromCharLiteral(char c) {
        return this.Sequence(this.Ch(c), this.WS(), new Object[0]);
    }

    protected Rule fromStringLiteral(String string) {
        return this.Sequence(this.String(string), this.WS(), new Object[0]);
    }

    public <T> List<T> popList(int start, Class<T> elementType, int additional) {
        Object element;
        LinkedList<Object> list = new LinkedList<Object>();
        while ((element = this.pop(start)) != LIST_BEGIN) {
            list.addFirst(element);
        }
        while (additional-- > 0) {
            list.addFirst(this.pop(start));
        }
        return new ArrayList(list);
    }

    public <T> List<T> popList(int start, Class<T> elementType) {
        return this.popList(start, elementType);
    }

    public <T> List<T> popList(Class<T> elementType, int additional) {
        return this.popList(0, elementType, additional);
    }

    public <T> List<T> popList(Class<T> elementType) {
        return this.popList(elementType, 0);
    }
}

