/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser.manchester;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.vocab.owl.DataRange;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.owl.Ontology;
import net.enilink.vocab.owl.Restriction;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.Class;
import net.enilink.vocab.rdfs.Datatype;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class ManchesterSyntaxGenerator {
    protected static final Comparator<? super IReference> REF_COMPARATOR = new Comparator<IReference>(){

        @Override
        public int compare(IReference o1, IReference o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    protected int indent = 0;
    protected static final String SPARQL_PREFIX = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> ";
    static final String FACET_QUERY = ManchesterSyntaxGenerator.createFacetQuery();
    static final Map<String, String> FACET_SHORTHANDS = new HashMap<String, String>();
    protected StringBuilder sb = new StringBuilder();

    protected void indent() {
        this.indent += 2;
    }

    protected void dedent() {
        this.indent -= 2;
    }

    protected void withIndent(Runnable runnable) {
        this.indent();
        runnable.run();
        this.dedent();
    }

    protected static String createFacetQuery() {
        StringBuilder sb = new StringBuilder("PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\n");
        sb.append("select ?facet ?value where {\n");
        Iterator<String> facets = Arrays.asList("length", "minLength", "maxLength", "pattern", "langPattern", "minInclusive", "minExclusive", "maxInclusive", "maxExclusive").iterator();
        while (facets.hasNext()) {
            String facet = "xsd:" + facets.next();
            sb.append("\t{ ?s ").append(facet).append(" ?value\n");
            sb.append("\tbind ( ").append(facet).append(" as ?facet ) }\n");
            if (!facets.hasNext()) continue;
            sb.append("\tunion\n");
        }
        sb.append("} limit 1");
        return sb.toString();
    }

    public String generateText(Object object) {
        if (object instanceof Class) {
            return this.clazz((Class)object, 0).toString();
        }
        return this.value(object).toString();
    }

    protected ManchesterSyntaxGenerator append(Object token) {
        if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == '\n') {
            for (int i = 0; i < this.indent; ++i) {
                this.sb.append(' ');
            }
        }
        this.sb.append(token);
        return this;
    }

    public String ontologyDocument(Ontology ontology) {
        IEntityManager em = ontology.getEntityManager();
        try (IExtendedIterator it = em.getNamespaces();){
            if (it.hasNext()) {
                it.forEach(ns -> this.prefix((INamespace)ns));
            }
            this.append("\n");
        }
        this.ontology(ontology);
        IQuery query = em.createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> SELECT DISTINCT ?class WHERE { { ?class a rdfs:Class } UNION { ?class a owl:Class } graph ?g { ?class ?someP ?someO }FILTER isIRI(?class) . } ORDER BY ?class");
        query.setParameter("g", (Object)ontology);
        try (IExtendedIterator it = query.evaluate(Class.class, new java.lang.Class[0]);){
            it.forEach(this::classDefinition);
        }
        return this.sb.toString();
    }

    protected ManchesterSyntaxGenerator prefix(INamespace ns) {
        this.append("Prefix: " + ns.getPrefix() + ":");
        this.value(ns.getURI());
        return this.append("\n");
    }

    protected ManchesterSyntaxGenerator ontology(Ontology ontology) {
        this.append("Ontology: ");
        this.value(ontology);
        this.append("\n");
        this.withIndent(() -> ontology.getOwlImports().stream().sorted(REF_COMPARATOR).forEachOrdered(this::ontologyImport));
        return this.append("\n");
    }

    protected ManchesterSyntaxGenerator ontologyImport(Ontology ontology) {
        this.append("Import: ");
        this.value(ontology);
        return this.append("\n");
    }

    protected ManchesterSyntaxGenerator classDefinition(Class clazz) {
        this.append("Class: ");
        this.value(clazz);
        this.append("\n");
        this.withIndent(() -> {
            this.class\u0154elation("SubClassOf", clazz.getRdfsSubClassOf());
            this.class\u0154elation("EquivalentTo", ((net.enilink.vocab.owl.Class)clazz).getOwlEquivalentClasses());
            this.class\u0154elation("DisjointWith", ((net.enilink.vocab.owl.Class)clazz).getOwlDisjointWith());
        });
        this.classDefinitionExt(clazz);
        return this;
    }

    protected void class\u0154elation(String key, Collection<? extends Class> elements) {
        ArrayList named = new ArrayList();
        ArrayList anonymous = new ArrayList();
        HashMap restrictions = new HashMap();
        elements.forEach(c -> {
            if (!OWL.TYPE_THING.equals(c)) {
                if (c.getURI() != null) {
                    named.add(c);
                } else if (c instanceof Restriction) {
                    Restriction r = (Restriction)c;
                    restrictions.compute(r.getOwlOnProperty(), (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<Restriction>();
                        }
                        v.add(r);
                        return v;
                    });
                } else {
                    anonymous.add(c);
                }
            }
        });
        this.appendKey(key, named, this::clazz);
        this.appendKey(key, anonymous, this::clazz);
        restrictions.entrySet().stream().sorted((a, b) -> REF_COMPARATOR.compare((IReference)a.getKey(), (IReference)b.getKey())).forEachOrdered(entry -> this.appendKey(key, (List)entry.getValue(), this::clazz));
    }

    private <T> void appendKey(String key, List<T> elements, Consumer<T> func) {
        if (!elements.isEmpty()) {
            this.append(key + ": ");
            Iterator<T> it = elements.iterator();
            while (it.hasNext()) {
                func.accept(it.next());
                if (!it.hasNext()) continue;
                this.append(", ");
            }
            this.append("\n");
        }
    }

    protected void classDefinitionExt(Class clazz) {
    }

    protected ManchesterSyntaxGenerator clazz(Class clazz) {
        return this.clazz(clazz, 0);
    }

    protected ManchesterSyntaxGenerator clazz(Class clazz, int prio) {
        if (clazz.getURI() == null) {
            if (clazz instanceof Restriction) {
                return this.restriction((Restriction)clazz, prio);
            }
            if (clazz instanceof Datatype && ((Datatype)clazz).getOwlOnDatatype() != null) {
                this.append(this.toString(((Datatype)clazz).getOwlOnDatatype()));
                return this.datatypeRestrictions(((Datatype)clazz).getOwlWithRestrictions());
            }
            if (clazz instanceof net.enilink.vocab.owl.Class) {
                net.enilink.vocab.owl.Class owlClass = (net.enilink.vocab.owl.Class)clazz;
                if (owlClass.getOwlUnionOf() != null) {
                    return this.setOfClasses(owlClass.getOwlUnionOf(), "or", 1, prio);
                }
                if (owlClass.getOwlIntersectionOf() != null) {
                    return this.setOfClasses(owlClass.getOwlIntersectionOf(), "and", 2, prio);
                }
                if (owlClass.getOwlComplementOf() != null) {
                    this.append("not ");
                    return this.clazz((Class)owlClass.getOwlComplementOf(), 3);
                }
                if (owlClass.getOwlOneOf() != null) {
                    return this.list(owlClass.getOwlOneOf());
                }
            }
        }
        return this.value(clazz);
    }

    protected ManchesterSyntaxGenerator datatypeRestrictions(List<?> list) {
        if (list != null) {
            this.append("[");
            Iterator<?> it = list.iterator();
            while (it.hasNext()) {
                IEntity dtRestriction = (IEntity)it.next();
                for (IBindings bindings : ((IQuery)dtRestriction.getEntityManager().createQuery(FACET_QUERY).setParameter("s", (Object)dtRestriction)).evaluate(IBindings.class, new java.lang.Class[0])) {
                    IReference facet = (IReference)bindings.get("facet");
                    String facetShortHand = FACET_SHORTHANDS.get(facet.getURI().localPart());
                    if (facetShortHand == null) {
                        facetShortHand = facet.getURI().localPart();
                    }
                    this.append(facetShortHand).append(this.toString(bindings.get("value")));
                    if (!it.hasNext()) continue;
                    this.append(", ");
                }
            }
            this.append("]");
        }
        return this;
    }

    protected ManchesterSyntaxGenerator dataRange(DataRange dataRange) {
        return this.clazz((Class)dataRange, 0);
    }

    private ManchesterSyntaxGenerator list(Collection<? extends Object> list) {
        this.append("{");
        Iterator<? extends Object> it = list.iterator();
        while (it.hasNext()) {
            this.value(it.next());
            if (!it.hasNext()) continue;
            this.append(", ").append(" ");
        }
        this.append("}");
        return this;
    }

    protected ManchesterSyntaxGenerator onClassOrDataRange(Restriction restriction) {
        if (restriction.getOwlOnClass() != null) {
            return this.clazz((Class)restriction.getOwlOnClass(), 0);
        }
        if (restriction.getOwlOnDataRange() != null) {
            return this.dataRange(restriction.getOwlOnDataRange());
        }
        return this;
    }

    public ManchesterSyntaxGenerator restriction(Restriction restriction, int prio) {
        if (restriction.getURI() == null) {
            int operatorPrio = 4;
            if (restriction.getOwlOnProperty() != null) {
                if (prio >= operatorPrio) {
                    this.append("(");
                }
                this.value(restriction.getOwlOnProperty());
            } else if (restriction.getOwlOnProperties() != null) {
                if (prio >= operatorPrio) {
                    this.append("(");
                }
                this.list(restriction.getOwlOnProperties());
            } else {
                return this.value(restriction);
            }
            this.append(" ");
            if (restriction.getOwlAllValuesFrom() != null) {
                this.append("only").append(" ");
                this.clazz(restriction.getOwlAllValuesFrom(), operatorPrio);
            } else if (restriction.getOwlSomeValuesFrom() != null) {
                this.append("some").append(" ");
                this.clazz(restriction.getOwlSomeValuesFrom(), operatorPrio);
            } else if (restriction.getOwlMaxCardinality() != null) {
                this.append("max").append(" ");
                this.append(restriction.getOwlMaxCardinality());
            } else if (restriction.getOwlMinCardinality() != null) {
                this.append("min").append(" ");
                this.append(restriction.getOwlMinCardinality());
            } else if (restriction.getOwlCardinality() != null) {
                this.append("exactly").append(" ");
                this.append(restriction.getOwlCardinality());
            } else if (restriction.getOwlMaxQualifiedCardinality() != null) {
                this.append("max").append(" ");
                this.append(restriction.getOwlMaxQualifiedCardinality()).append(" ");
                this.onClassOrDataRange(restriction);
            } else if (restriction.getOwlMinQualifiedCardinality() != null) {
                this.append("min").append(" ");
                this.append(restriction.getOwlMinQualifiedCardinality()).append(" ");
                this.onClassOrDataRange(restriction);
            } else if (restriction.getOwlQualifiedCardinality() != null) {
                this.append("exactly").append(" ");
                this.append(restriction.getOwlQualifiedCardinality()).append(" ");
                this.onClassOrDataRange(restriction);
            } else if (restriction.getOwlHasValue() != null) {
                this.append("value").append(" ");
                this.value(restriction.getOwlHasValue());
            }
            if (prio >= operatorPrio) {
                this.append(")");
            }
            return this;
        }
        return this.value(restriction);
    }

    protected ManchesterSyntaxGenerator setOfClasses(List<? extends Class> set, String operator, int operatorPrio, int prio) {
        Iterator<? extends Class> it = set.iterator();
        if (operatorPrio < prio && set.size() > 1) {
            this.append("(");
        }
        while (it.hasNext()) {
            this.clazz(it.next(), operatorPrio);
            if (!it.hasNext()) continue;
            this.append(" ").append(operator).append(" ");
        }
        if (operatorPrio < prio && set.size() > 1) {
            this.append(")");
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    protected String escapeLiteral(String label) {
        return label.replace("\\", "\\\\").replace("\t", "\\t").replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"");
    }

    protected ManchesterSyntaxGenerator value(Object value) {
        if (value instanceof ILiteral) {
            boolean quoted;
            ILiteral literal = (ILiteral)value;
            boolean bl = quoted = XMLSCHEMA.TYPE_STRING.equals((Object)literal.getDatatype()) || RDF.TYPE_LANGSTRING.equals((Object)literal.getDatatype()) || literal.getDatatype() == null;
            if (quoted) {
                this.append("\"");
            }
            this.append(this.escapeLiteral(literal.getLabel()));
            if (quoted) {
                this.append("\"");
            }
            if (literal.getLanguage() != null) {
                this.append("@").append(this.toString(literal.getLanguage()));
            } else if (literal.getDatatype() != null) {
                this.append("^^").append(this.toString(literal.getDatatype()));
            }
        } else {
            this.append(this.toString(value));
        }
        return this;
    }

    protected String getPrefix(IReference reference) {
        if (reference instanceof IEntity) {
            return ((IEntity)reference).getEntityManager().getPrefix(reference.getURI().namespace());
        }
        return null;
    }

    protected String toString(Object value) {
        URI uri;
        if (value instanceof IReference && (uri = ((IReference)value).getURI()) != null) {
            String prefix = this.getPrefix((IReference)value);
            String localPart = uri.localPart();
            boolean hasLocalPart = localPart != null && localPart.length() > 0;
            StringBuilder text = new StringBuilder();
            if (prefix != null && prefix.length() > 0 && hasLocalPart) {
                text.append(prefix).append(":");
            }
            if (hasLocalPart && prefix != null) {
                text.append(localPart);
            } else {
                text.append("<").append(uri.toString()).append(">");
            }
            return text.toString();
        }
        return String.valueOf(value);
    }

    static {
        FACET_SHORTHANDS.put("minInclusive", "<=");
        FACET_SHORTHANDS.put("minExclusive", "<");
        FACET_SHORTHANDS.put("maxInclusive", ">=");
        FACET_SHORTHANDS.put("maxExclusive", ">");
    }
}

