/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser.sparql.tree;

import java.util.Arrays;
import java.util.Collection;
import net.enilink.komma.parser.sparql.tree.Dataset;
import net.enilink.komma.parser.sparql.tree.Graph;
import net.enilink.komma.parser.sparql.tree.LimitModifier;
import net.enilink.komma.parser.sparql.tree.OffsetModifier;
import net.enilink.komma.parser.sparql.tree.OrderModifier;
import net.enilink.komma.parser.sparql.tree.Query;
import net.enilink.komma.parser.sparql.tree.SolutionModifier;

public abstract class QueryWithSolutionModifier
extends Query {
    protected LimitModifier limitModifier;
    protected OffsetModifier offsetModifier;
    protected OrderModifier orderModifier;
    protected SolutionModifier[] modifiers;

    public QueryWithSolutionModifier(Dataset dataset, Graph graph, SolutionModifier ... modifiers) {
        super(dataset, graph);
        this.modifiers = modifiers;
        for (SolutionModifier modifier : modifiers) {
            if (modifier instanceof LimitModifier) {
                this.assertNull(LimitModifier.class, this.limitModifier);
                this.limitModifier = (LimitModifier)modifier;
                continue;
            }
            if (modifier instanceof OffsetModifier) {
                this.assertNull(OffsetModifier.class, this.offsetModifier);
                this.offsetModifier = (OffsetModifier)modifier;
                continue;
            }
            if (!(modifier instanceof OrderModifier)) continue;
            this.assertNull(OrderModifier.class, this.orderModifier);
            this.orderModifier = (OrderModifier)modifier;
        }
    }

    public LimitModifier getLimitModifier() {
        return this.limitModifier;
    }

    public OffsetModifier getOffsetModifier() {
        return this.offsetModifier;
    }

    public OrderModifier getOrderModifier() {
        return this.orderModifier;
    }

    public Collection<? extends SolutionModifier> getModifiers() {
        return Arrays.asList(this.modifiers);
    }

    protected <T> void assertNull(Class<T> type, T value) {
        if (value != null) {
            throw new IllegalArgumentException("Modifier of type " + type + " may only be assigned once.");
        }
    }
}

