/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;

public class BlankNode
implements IReference {
    private static long lastPrefixId = 0L;
    private static String idPrefix = BlankNode.nextIdPrefix();
    private static int nextId;
    private String id;

    private static synchronized String nextIdPrefix() {
        lastPrefixId = Math.max(System.currentTimeMillis(), lastPrefixId + 1L);
        return Long.toString(lastPrefixId, 32) + "x";
    }

    public static String generateId() {
        return BlankNode.generateId(null);
    }

    public static synchronized String generateId(String prefix) {
        int id = nextId++;
        String idStr = "_:" + (prefix == null ? "komma-" : prefix) + idPrefix + id;
        if (id == Integer.MAX_VALUE) {
            idPrefix = BlankNode.nextIdPrefix();
        }
        return idStr;
    }

    public BlankNode() {
        this(BlankNode.generateId());
    }

    public BlankNode(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlankNode other = (BlankNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public URI getURI() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.id;
    }
}

