/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.Namespace;
import net.enilink.komma.core.URI;

public class KommaModule {
    private static final String IRI_CLASS = "net.enilink.composition.annotations.Iri";
    private final CombinedClassLoader cl;
    private Map<Class<?>, Association> annotations = new HashMap();
    private Set<Association> datatypes = new HashSet<Association>();
    private Set<Association> concepts = new HashSet<Association>();
    private Set<Association> behaviours = new HashSet<Association>();
    private Set<URI> readableGraphs = new LinkedHashSet<URI>();
    private Set<URI> writableGraphs = new LinkedHashSet<URI>();
    private Set<INamespace> namespaces = new HashSet<INamespace>();

    public KommaModule() {
        this.cl = new CombinedClassLoader(this.getClass().getClassLoader());
    }

    public KommaModule(ClassLoader classLoader) {
        this.cl = new CombinedClassLoader(classLoader);
        this.cl.addAlternative(this.getClass().getClassLoader());
    }

    public KommaModule addAnnotation(Class<?> annotation) {
        String uri = null;
        for (Method m : annotation.getDeclaredMethods()) {
            block3: for (Annotation methodAnnotation : m.getAnnotations()) {
                for (Class<?> itf : methodAnnotation.getClass().getInterfaces()) {
                    if (!itf.getName().equals(IRI_CLASS)) continue;
                    try {
                        uri = (String)methodAnnotation.getClass().getMethod("value", new Class[0]).invoke((Object)methodAnnotation, new Object[0]);
                        continue block3;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (uri == null) {
            throw new IllegalArgumentException("@Iri annotation required on method of " + annotation.getSimpleName());
        }
        this.addAnnotation(annotation, uri);
        return this;
    }

    public KommaModule addAnnotation(Class<?> annotation, String type) {
        Association registered = this.annotations.get(annotation);
        if (registered != null && !registered.getRdfType().equals(type)) {
            throw new IllegalArgumentException("annotation is already associated to type " + registered.getRdfType());
        }
        this.annotations.put(annotation, new Association(annotation, type));
        return this;
    }

    public KommaModule addBehaviour(Class<?> behaviour) {
        this.behaviours.add(new Association(behaviour, null));
        return this;
    }

    public KommaModule addBehaviour(Class<?> behaviour, String type) {
        this.behaviours.add(new Association(behaviour, type));
        return this;
    }

    public KommaModule addConcept(Class<?> concept) {
        this.concepts.add(new Association(concept, null));
        return this;
    }

    public KommaModule addConcept(Class<?> concept, String type) {
        this.concepts.add(new Association(concept, type));
        return this;
    }

    public KommaModule addDatatype(Class<?> type, String uri) {
        this.datatypes.add(new Association(type, uri));
        return this;
    }

    public KommaModule addNamespace(String prefix, URI uri) {
        this.namespaces.add(new Namespace(prefix, uri));
        return this;
    }

    public KommaModule addReadableGraph(URI graph) {
        this.readableGraphs.add(graph);
        return this;
    }

    public KommaModule addWritableGraph(URI graph) {
        this.writableGraphs.add(graph);
        this.addReadableGraph(graph);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KommaModule other = (KommaModule)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.behaviours == null ? other.behaviours != null : !this.behaviours.equals(other.behaviours)) {
            return false;
        }
        if (this.cl == null ? other.cl != null : !this.cl.equals(other.cl)) {
            return false;
        }
        if (this.concepts == null ? other.concepts != null : !this.concepts.equals(other.concepts)) {
            return false;
        }
        if (this.datatypes == null ? other.datatypes != null : !this.datatypes.equals(other.datatypes)) {
            return false;
        }
        if (this.readableGraphs == null ? other.readableGraphs != null : !this.readableGraphs.equals(other.readableGraphs)) {
            return false;
        }
        return !(this.writableGraphs == null ? other.writableGraphs != null : !this.writableGraphs.equals(other.writableGraphs));
    }

    public Collection<Association> getAnnotations() {
        return this.annotations.values();
    }

    public Collection<Association> getBehaviours() {
        return Collections.unmodifiableSet(this.behaviours);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.cl;
    }

    public Collection<Association> getConcepts() {
        return Collections.unmodifiableSet(this.concepts);
    }

    public Collection<Association> getDatatypes() {
        return Collections.unmodifiableSet(this.datatypes);
    }

    public Set<INamespace> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    public Set<URI> getReadableGraphs() {
        return Collections.unmodifiableSet(this.readableGraphs);
    }

    public Set<URI> getWritableGraphs() {
        return Collections.unmodifiableSet(this.writableGraphs);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.behaviours == null ? 0 : this.behaviours.hashCode());
        result = 31 * result + (this.cl == null ? 0 : this.cl.hashCode());
        result = 31 * result + (this.concepts == null ? 0 : this.concepts.hashCode());
        result = 31 * result + (this.datatypes == null ? 0 : this.datatypes.hashCode());
        result = 31 * result + (this.readableGraphs == null ? 0 : this.readableGraphs.hashCode());
        result = 31 * result + (this.writableGraphs == null ? 0 : this.writableGraphs.hashCode());
        return result;
    }

    public KommaModule includeModule(KommaModule module) {
        return this.includeModule(module, true);
    }

    public KommaModule includeModule(KommaModule module, boolean includeGraphs) {
        this.annotations.putAll(module.annotations);
        this.datatypes.addAll(module.datatypes);
        this.concepts.addAll(module.concepts);
        this.behaviours.addAll(module.behaviours);
        if (includeGraphs) {
            this.readableGraphs.addAll(module.writableGraphs);
            this.readableGraphs.addAll(module.readableGraphs);
            this.namespaces.addAll(module.namespaces);
        }
        if (!this.cl.equals(module.cl)) {
            this.cl.addAlternative(module.cl);
        }
        return this;
    }

    public String toString() {
        if (!this.writableGraphs.isEmpty()) {
            return this.writableGraphs.toString();
        }
        LinkedHashSet<Package> pkg = new LinkedHashSet<Package>();
        for (Association concept : this.concepts) {
            pkg.add(concept.getJavaClass().getPackage());
        }
        return ((Object)pkg).toString();
    }

    private static class CombinedClassLoader
    extends ClassLoader {
        private Set<ClassLoader> alternatives;

        public CombinedClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void addAlternative(ClassLoader loader) {
            if (this.alternatives == null) {
                this.alternatives = new LinkedHashSet<ClassLoader>();
            }
            if (loader instanceof CombinedClassLoader) {
                this.alternatives.add(loader.getParent());
                if (((CombinedClassLoader)loader).alternatives != null) {
                    this.alternatives.addAll(((CombinedClassLoader)loader).alternatives);
                }
            } else {
                this.alternatives.add(loader);
            }
            this.alternatives.remove(this.getParent());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.alternatives != null) {
                for (ClassLoader alt : this.alternatives) {
                    try {
                        return alt.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            URL resource;
            block1: {
                ClassLoader alt;
                resource = null;
                if (this.alternatives == null) break block1;
                Iterator<ClassLoader> iterator = this.alternatives.iterator();
                while (iterator.hasNext() && (resource = (alt = iterator.next()).getResource(name)) == null) {
                }
            }
            return resource;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (this.alternatives != null) {
                Vector<URL> list = new Vector<URL>();
                for (ClassLoader alt : this.alternatives) {
                    Enumeration<URL> e = alt.getResources(name);
                    while (e.hasMoreElements()) {
                        list.add(e.nextElement());
                    }
                }
                return list.elements();
            }
            return Collections.emptyEnumeration();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getParent() == null ? 0 : this.getParent().hashCode());
            result = 31 * result + (this.alternatives == null ? 0 : this.alternatives.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CombinedClassLoader)) {
                return false;
            }
            CombinedClassLoader other = (CombinedClassLoader)obj;
            if (this.getParent() == null ? other.getParent() != null : !this.getParent().equals(other.getParent())) {
                return false;
            }
            return !(this.alternatives == null ? other.alternatives != null : !this.alternatives.equals(other.alternatives));
        }
    }

    public static class Association {
        private Class<?> javaClass;
        private String rdfType;

        private Association(Class<?> javaClass, String rdfType) {
            this.javaClass = javaClass;
            this.rdfType = rdfType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Association other = (Association)obj;
            if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
                return false;
            }
            return !(this.rdfType == null ? other.rdfType != null : !this.rdfType.equals(other.rdfType));
        }

        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        public String getRdfType() {
            return this.rdfType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
            result = 31 * result + (this.rdfType == null ? 0 : this.rdfType.hashCode());
            return result;
        }

        public String toString() {
            return this.javaClass.getName() + "=" + this.rdfType;
        }
    }
}

