/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.enilink.komma.core.IBindings;

public class LinkedHashBindings<T>
implements IBindings<T> {
    private Map<String, T> values = new LinkedHashMap<String, T>();

    public LinkedHashBindings() {
        this(10);
    }

    public LinkedHashBindings(int size) {
        this.values = new LinkedHashMap<String, T>(size);
    }

    public void put(String key, T value) {
        this.values.put(key, value);
    }

    @Override
    public T get(String key) {
        return this.values.get(key);
    }

    @Override
    public Collection<String> getKeys() {
        return this.values.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.values().iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedHashBindings other = (LinkedHashBindings)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.values.toString();
    }
}

