/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import net.enilink.komma.core.IDialect;
import net.enilink.komma.core.LinkedHashBindings;
import net.enilink.komma.core.QueryFragment;

public class SparqlStandardDialect
implements IDialect {
    protected volatile int varCount = 0;
    private static Pattern ESCAPE_CHARS = Pattern.compile("[\\[.{(*+?^$|]");

    protected String createVar(String prefix) {
        return prefix + Integer.toString(this.varCount++, 36);
    }

    protected String createRegexForPattern(String searchPattern, int flags) {
        searchPattern = ESCAPE_CHARS.matcher(searchPattern).replaceAll("\\\\$0");
        return searchPattern.replace("\\*", ".*").replace("\\?", ".");
    }

    protected String[] filterEmpty(String[] patterns) {
        ArrayList<String> nonEmpty = new ArrayList<String>(patterns.length);
        for (String pattern : patterns) {
            if (pattern == null || (pattern = pattern.trim()).length() <= 0) continue;
            nonEmpty.add(pattern);
        }
        return nonEmpty.toArray(new String[nonEmpty.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public QueryFragment fullTextSearch(Collection<? extends String> bindingNames, int flags, String ... patterns) {
        boolean caseSensitive = (flags & 2) != 0;
        if ((patterns = this.filterEmpty(patterns)).length > 0) {
            void var9_16;
            LinkedHashBindings<Object> bindings = new LinkedHashBindings<Object>();
            if ((flags & 1) == 0) {
                StringBuilder regex = new StringBuilder();
                for (int i = 0; i < patterns.length; ++i) {
                    String pattern = patterns[i];
                    regex.append(this.createRegexForPattern(pattern, flags));
                    if (i >= patterns.length - 1) continue;
                    regex.append("|");
                }
                String var = this.createVar("pattern_");
                bindings.put(var, regex.toString());
                StringBuilder filter = new StringBuilder();
                for (String string : bindingNames) {
                    if (filter.length() > 0) {
                        filter.append(" || ");
                    }
                    filter.append("regex(str(?" + string + "), ?" + var + (caseSensitive ? "" : ", \"i\"") + ")");
                }
                return new QueryFragment("FILTER (" + filter + ")", bindings);
            }
            ArrayList<String> vars = new ArrayList<String>();
            String[] var = patterns;
            int n = var.length;
            boolean bl = false;
            while (var9_16 < n) {
                String string = var[var9_16];
                String var2 = this.createVar("pattern_");
                vars.add(var2);
                bindings.put(var2, this.createRegexForPattern(string, flags));
                ++var9_16;
            }
            StringBuilder filter = new StringBuilder();
            for (String string : bindingNames) {
                if (filter.length() > 0) {
                    filter.append(" || ");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String var3 : vars) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" && ");
                    }
                    stringBuilder.append("regex(str(?" + string + "), ?").append(var3).append(caseSensitive ? "" : ", \"i\"").append(")");
                }
                filter.append((CharSequence)stringBuilder);
            }
            return new QueryFragment("FILTER (" + filter + ")", bindings);
        }
        return new QueryFragment("");
    }
}

