/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.assist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.enilink.komma.edit.assist.ContentProposal;
import net.enilink.komma.edit.assist.IContentProposal;
import net.enilink.komma.edit.assist.IContentProposalProvider;
import net.enilink.komma.edit.assist.ISemanticProposal;
import net.enilink.komma.edit.assist.ISemanticProposalProvider;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.matchervisitors.DefaultMatcherVisitor;
import org.parboiled.matchervisitors.FollowMatchersVisitor;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.support.Characters;
import org.parboiled.support.ParsingResult;

public class ParboiledProposalProvider
implements IContentProposalProvider {
    Rule rule;
    ISemanticProposalProvider semanticProposalProvider;

    public ParboiledProposalProvider(Rule rule, ISemanticProposalProvider semanticProposalProvider) {
        this.rule = rule;
        this.semanticProposalProvider = semanticProposalProvider;
    }

    @Override
    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<IContentProposal> proposals = new ArrayList<IContentProposal>();
        ProposalParseRunner runner = new ProposalParseRunner(this.rule, position, this.semanticProposalProvider);
        ParsingResult result = runner.run(contents);
        for (Map.Entry<ISemanticProposal, String> entry : runner.getSemanticProposals().entrySet()) {
            IContentProposal[] computedProposals = entry.getKey().compute(result, position, entry.getValue());
            if (computedProposals == null) continue;
            for (IContentProposal proposal : computedProposals) {
                proposals.add(proposal);
            }
        }
        for (Proposal proposal : runner.getWords()) {
            proposals.add(new ContentProposal(proposal.content, proposal.label, proposal.label));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    static class ProposalParseRunner
    extends BasicParseRunner<Object> {
        int proposalIndex;
        ISemanticProposalProvider proposalProvider;
        Map<ISemanticProposal, String> semanticProposals = new HashMap<ISemanticProposal, String>();
        CollectProposalsVisitor visitor;

        ProposalParseRunner(Rule rule, int proposalIndex, ISemanticProposalProvider proposalProvider) {
            super(rule);
            this.proposalIndex = proposalIndex;
            this.proposalProvider = proposalProvider;
        }

        private String getLastWord(MatcherContext<?> context) {
            String prefix = this.getPrefix(context);
            if (prefix.matches(".*\\s$")) {
                return "";
            }
            String[] words = prefix.split("\\s");
            return words[words.length - 1];
        }

        private String getPrefix(MatcherContext<?> context) {
            return context.getInputBuffer().extract(context.getStartIndex(), this.proposalIndex);
        }

        public Map<ISemanticProposal, String> getSemanticProposals() {
            return this.semanticProposals;
        }

        public Set<Proposal> getWords() {
            return new TreeSet<Proposal>(this.visitor.getWords());
        }

        public boolean match(MatcherContext<?> context) {
            String prefix;
            boolean matched = context.getMatcher().match(context);
            if (!matched && context.getStartIndex() <= this.proposalIndex && !(prefix = this.getPrefix(context)).matches(".*\\S.*\\s$")) {
                this.visitor.process(prefix, false, context.getMatcher());
            }
            if (this.proposalIndex == context.getCurrentIndex()) {
                String lastWord = this.getLastWord(context);
                List matchers = new FollowMatchersVisitor().getFollowMatchers(context);
                for (Matcher matcher : matchers) {
                    this.visitor.process(lastWord, true, matcher);
                }
                if (this.proposalProvider != null) {
                    do {
                        ISemanticProposal proposal;
                        if ((proposal = this.proposalProvider.getProposal(context.getMatcher().getLabel())) == null || this.semanticProposals.containsKey(proposal)) continue;
                        this.semanticProposals.put(proposal, this.getPrefix(context));
                        break;
                    } while ((context = context.getParent()) != null);
                }
            }
            return matched;
        }

        public ParsingResult<Object> run(InputBuffer inputBuffer) {
            this.visitor = new CollectProposalsVisitor(this.proposalProvider, this.semanticProposals);
            return super.run(inputBuffer);
        }
    }

    static class Proposal
    implements Comparable<Proposal> {
        String content;
        String label;

        public Proposal(String content, String label) {
            this.content = content;
            this.label = label;
        }

        @Override
        public int compareTo(Proposal o) {
            return this.label.compareTo(o.label);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Proposal other = (Proposal)obj;
            if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public String toString() {
            return "{content : \"" + this.content + "\", label : \"" + this.label + "\"}";
        }
    }

    static class CollectProposalsVisitor
    extends DefaultMatcherVisitor<Boolean> {
        Set<Matcher> active = new HashSet<Matcher>();
        boolean includeSemanticProposals;
        int optional = 0;
        String prefix;
        ISemanticProposalProvider proposalProvider;
        Map<ISemanticProposal, String> semanticProposals;
        Characters separators = Characters.of((char[])new char[]{' ', '\n', '\r', '\t', '\f', '\uffff'});
        StringBuilder word;
        LinkedHashSet<Proposal> words = new LinkedHashSet();

        public CollectProposalsVisitor(ISemanticProposalProvider proposalProvider, Map<ISemanticProposal, String> semanticProposals) {
            this.proposalProvider = proposalProvider;
            this.semanticProposals = semanticProposals;
        }

        protected boolean addSemanticProposal(Matcher matcher) {
            if (this.proposalProvider == null || !this.includeSemanticProposals) {
                return false;
            }
            ISemanticProposal proposal = this.proposalProvider.getProposal(matcher.getLabel());
            if (proposal != null && !this.semanticProposals.containsKey(proposal)) {
                this.semanticProposals.put(proposal, this.prefix);
                return true;
            }
            return false;
        }

        protected void addWord(String word) {
            if (this.prefix == null || word.startsWith(this.prefix)) {
                if (word.equals(this.prefix)) {
                    return;
                }
                String content = this.prefix == null ? word : word.substring(this.prefix.length());
                this.words.add(new Proposal(content, word));
            }
        }

        public Boolean defaultValue(AbstractMatcher matcher) {
            this.addSemanticProposal((Matcher)matcher);
            return this.word.length() > 0;
        }

        public LinkedHashSet<Proposal> getWords() {
            return this.words;
        }

        boolean isOptional() {
            return this.optional > 0;
        }

        public void process(String prefix, boolean includeSemanticProposals, Matcher matcher) {
            this.active.clear();
            this.prefix = prefix;
            this.includeSemanticProposals = includeSemanticProposals;
            this.word = new StringBuilder();
            if (((Boolean)matcher.accept((MatcherVisitor)this)).booleanValue() && this.word.length() > 0) {
                this.addWord(this.word.toString());
            }
        }

        public Boolean visit(ActionMatcher matcher) {
            return false;
        }

        public Boolean visit(CharIgnoreCaseMatcher matcher) {
            this.addSemanticProposal((Matcher)matcher);
            this.word.append(matcher.charLow);
            return false;
        }

        public Boolean visit(CharMatcher matcher) {
            this.addSemanticProposal((Matcher)matcher);
            this.word.append(matcher.character);
            return false;
        }

        public Boolean visit(FirstOfMatcher matcher) {
            if (!this.active.add((Matcher)matcher)) {
                return false;
            }
            this.addSemanticProposal((Matcher)matcher);
            boolean complete = false;
            for (Matcher child : matcher.getChildren()) {
                int length = this.word.length();
                boolean accept = (Boolean)child.accept((MatcherVisitor)this);
                complete |= accept;
                if (accept && this.word.length() > length) {
                    this.addWord(this.word.toString());
                }
                this.word.replace(length, this.word.length(), "");
            }
            this.active.remove(matcher);
            return complete;
        }

        public Boolean visit(OneOrMoreMatcher matcher) {
            if (!this.active.add((Matcher)matcher)) {
                return false;
            }
            this.addSemanticProposal((Matcher)matcher);
            try {
                Boolean bl = (Boolean)matcher.subMatcher.accept((MatcherVisitor)this);
                return bl;
            }
            finally {
                this.active.remove(matcher);
            }
        }

        public Boolean visit(OptionalMatcher matcher) {
            this.addSemanticProposal((Matcher)matcher);
            if (this.word.length() > 0) {
                return true;
            }
            if (!this.active.add((Matcher)matcher)) {
                return false;
            }
            try {
                ++this.optional;
                Boolean bl = (Boolean)matcher.subMatcher.accept((MatcherVisitor)this);
                return bl;
            }
            finally {
                --this.optional;
                this.active.remove(matcher);
            }
        }

        public Boolean visit(SequenceMatcher matcher) {
            if (!this.active.add((Matcher)matcher)) {
                return false;
            }
            this.addSemanticProposal((Matcher)matcher);
            for (Matcher child : matcher.getChildren()) {
                if (!((Boolean)child.accept((MatcherVisitor)this)).booleanValue()) continue;
                return true;
            }
            this.active.remove(matcher);
            return false;
        }

        public Boolean visit(ZeroOrMoreMatcher matcher) {
            this.addSemanticProposal((Matcher)matcher);
            if (this.word.length() > 0) {
                return true;
            }
            if (!this.active.add((Matcher)matcher)) {
                return false;
            }
            try {
                ++this.optional;
                Boolean bl = (Boolean)matcher.subMatcher.accept((MatcherVisitor)this);
                return bl;
            }
            finally {
                --this.optional;
                this.active.remove(matcher);
            }
        }
    }
}

