/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import net.enilink.commons.util.Pair;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.command.IChildrenToCopyProvider;
import net.enilink.komma.edit.command.IOverrideableCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractOverrideableCommand
extends AbstractCommand
implements IOverrideableCommand {
    private IEditingDomain domain;
    protected ICommand overrideCommand;

    public static Collection<Object> getOwnerList(IResource owner, IReference property) {
        Object value;
        Pair cardinality = owner.getApplicableCardinality(property);
        if ((Integer)cardinality.getSecond() != 1 && (value = owner.get(property)) instanceof Collection) {
            return (Collection)value;
        }
        return null;
    }

    protected AbstractOverrideableCommand(IEditingDomain domain) {
        this(domain, null, null);
    }

    protected AbstractOverrideableCommand(IEditingDomain domain, String label) {
        this(domain, label, null);
    }

    protected AbstractOverrideableCommand(IEditingDomain domain, String label, String description) {
        super(label, description);
        this.domain = domain;
    }

    public final boolean canExecute() {
        if (this.getDomain() != null && !this.isPrepared) {
            ICommand newOverrideCommand = this.getDomain().createOverrideCommand(this);
            this.setOverride(newOverrideCommand);
        }
        boolean result = this.overrideCommand != null ? this.overrideCommand.canExecute() : this.doCanExecute();
        return result;
    }

    public final boolean canRedo() {
        boolean result = this.overrideCommand != null ? this.overrideCommand.canRedo() : this.doCanRedo();
        return result;
    }

    public final boolean canUndo() {
        boolean result = this.overrideCommand != null ? this.overrideCommand.canUndo() : this.doCanUndo();
        return result;
    }

    public final void dispose() {
        if (this.overrideCommand != null) {
            this.overrideCommand.dispose();
        } else {
            this.doDispose();
        }
    }

    @Override
    public boolean doCanExecute() {
        return super.canExecute();
    }

    public boolean doCanRedo() {
        return super.canRedo();
    }

    @Override
    public boolean doCanUndo() {
        return super.canUndo();
    }

    @Override
    public void doDispose() {
        super.dispose();
    }

    @Override
    public IStatus doExecute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return super.execute(progressMonitor, info);
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return super.getAffectedObjects();
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        return super.getAffectedResources(type);
    }

    public Collection<?> doGetChildrenToCopy() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public CommandResult doGetCommandResult() {
        return super.getCommandResult();
    }

    @Override
    public String doGetDescription() {
        return super.getDescription();
    }

    @Override
    public String doGetLabel() {
        return super.getLabel();
    }

    @Override
    public IStatus doRedo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return super.redo(progressMonitor, info);
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    @Override
    public IStatus doUndo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return super.undo(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.overrideCommand != null) {
            return this.overrideCommand.execute(progressMonitor, info);
        }
        return this.doExecute(progressMonitor, info);
    }

    public final Collection<?> getAffectedObjects() {
        return this.overrideCommand != null ? this.overrideCommand.getAffectedObjects() : this.doGetAffectedObjects();
    }

    public Collection<?> getAffectedResources(Object type) {
        return this.overrideCommand != null ? this.overrideCommand.getAffectedResources(type) : this.doGetAffectedResources(type);
    }

    public final Collection<?> getChildrenToCopy() {
        Collection<?> result = this.overrideCommand instanceof IChildrenToCopyProvider ? ((IChildrenToCopyProvider)this.overrideCommand).getChildrenToCopy() : this.doGetChildrenToCopy();
        return result;
    }

    public final CommandResult getCommandResult() {
        return this.overrideCommand != null ? this.overrideCommand.getCommandResult() : this.doGetCommandResult();
    }

    public final String getDescription() {
        return this.overrideCommand != null ? this.overrideCommand.getDescription() : this.doGetDescription();
    }

    public IEditingDomain getDomain() {
        return this.domain;
    }

    public final String getLabel() {
        return this.overrideCommand != null ? this.overrideCommand.getLabel() : this.doGetLabel();
    }

    @Override
    public ICommand getOverride() {
        return this.overrideCommand;
    }

    public IStatus redo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.overrideCommand != null) {
            return this.overrideCommand.redo(progressMonitor, info);
        }
        return this.doRedo(progressMonitor, info);
    }

    @Override
    public void setOverride(ICommand overrideCommand) {
        this.overrideCommand = overrideCommand;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.getDomain() + ")");
        result.append(" (overrideCommand: " + this.overrideCommand + ")");
        return result.toString();
    }

    public IStatus undo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.overrideCommand != null) {
            return this.overrideCommand.undo(progressMonitor, info);
        }
        return this.doUndo(progressMonitor, info);
    }
}

