/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.vocab.rdfs.Class;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddCommand
extends AbstractOverrideableCommand {
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_AddCommand_description");
    protected static final String DESCRIPTION_FOR_LIST = KommaEditPlugin.INSTANCE.getString("_UI_AddCommand_description_for_list");
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_AddCommand_label");
    protected Collection<?> affectedObjects;
    protected Collection<?> collection;
    protected int index;
    protected IResource owner;
    protected Collection<Object> ownerList;
    protected IReference property;

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Collection<?> collection) {
        return domain.createCommand(AddCommand.class, new CommandParameter(owner, property, collection, -1));
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Collection<?> collection, int index) {
        return domain.createCommand(AddCommand.class, new CommandParameter(owner, property, collection, index));
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Object value) {
        return AddCommand.create(domain, owner, property, Collections.singleton(value), -1);
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Object value, int index) {
        return AddCommand.create(domain, owner, property, Collections.singleton(value), index);
    }

    public AddCommand(IEditingDomain domain, Collection<?> list, Collection<?> collection) {
        this(domain, list, collection, -1);
    }

    public AddCommand(IEditingDomain domain, Collection<?> list, Collection<?> collection, int index) {
        super(domain, LABEL, DESCRIPTION_FOR_LIST);
        this.collection = collection;
        this.index = index;
        Collection<?> untypedList = list;
        this.ownerList = untypedList;
    }

    public AddCommand(IEditingDomain domain, Collection<?> list, Object value) {
        this(domain, list, Collections.singleton(value), -1);
    }

    public AddCommand(IEditingDomain domain, Collection<?> list, Object value, int index) {
        this(domain, list, Collections.singleton(value), index);
    }

    public AddCommand(IEditingDomain domain, IResource owner, IReference property, Collection<?> collection) {
        this(domain, owner, property, collection, -1);
    }

    public AddCommand(IEditingDomain domain, IResource owner, IReference property, Collection<?> collection, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = property;
        this.collection = collection;
        this.index = index;
        this.ownerList = AddCommand.getOwnerList(owner, property);
    }

    public AddCommand(IEditingDomain domain, IResource owner, IReference property, Object value) {
        this(domain, owner, property, Collections.singleton(value), -1);
    }

    public AddCommand(IEditingDomain domain, IResource owner, IReference property, Object value, int index) {
        this(domain, owner, property, Collections.singleton(value), index);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        boolean transactionWasActive = this.owner.getEntityManager().getTransaction().isActive();
        if (!transactionWasActive) {
            this.owner.getEntityManager().getTransaction().begin();
        }
        try {
            Class listClass = this.getListType();
            if (listClass != null) {
                List newList;
                this.ownerList = newList = (List)((IClass)listClass).newInstance();
            }
            if (this.ownerList instanceof List && this.index != -1) {
                ((List)this.ownerList).addAll(this.index, this.collection);
            } else {
                this.ownerList.addAll(this.collection);
            }
            this.affectedObjects = this.collection;
            if (!transactionWasActive) {
                this.owner.getEntityManager().getTransaction().commit();
            }
        }
        catch (Throwable e) {
            if (!transactionWasActive) {
                this.owner.getEntityManager().getTransaction().rollback();
            }
            throw new ExecutionException("Error while adding element", e);
        }
        return CommandResult.newOKCommandResult(this.collection);
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.affectedObjects;
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && (this.owner != null || this.ownerList != null || this.collection != null)) {
            Object object;
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            if (this.owner instanceof IObject) {
                affected.add(((IObject)this.owner).getModel());
            }
            if (this.ownerList != null) {
                for (Object element : this.ownerList) {
                    object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            if (this.collection != null) {
                for (Object element : this.collection) {
                    object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doRedoWithResult(progressMonitor, info);
        this.affectedObjects = this.collection;
        return result;
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doUndoWithResult(progressMonitor, info);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
        return result;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public int getIndex() {
        return this.index;
    }

    protected Class getListType() {
        if (this.ownerList == null) {
            IProperty property = (IProperty)this.owner.getEntityManager().find(this.property, IProperty.class, new java.lang.Class[0]);
            for (Class clazz : property.getNamedRanges((IEntity)this.owner, true)) {
                if (clazz.getURI() == null) continue;
                return clazz;
            }
        }
        return null;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public Collection<?> getOwnerList() {
        return this.ownerList;
    }

    public IReference getProperty() {
        return this.property;
    }

    protected boolean prepare() {
        if (this.ownerList == null && this.getListType() == null || this.collection == null || this.collection.size() == 0 || this.index != -1 && (this.index < 0 || this.ownerList != null && this.index > this.ownerList.size())) {
            return false;
        }
        if (this.property != null) {
            IProperty property = (IProperty)this.owner.getEntityManager().find(this.property, IProperty.class, new java.lang.Class[0]);
            for (Object object : this.collection) {
                boolean containment = false;
                if (!(containment |= property.isContainment())) continue;
                HashSet<IResource> seen = new HashSet<IResource>();
                for (IResource container = this.owner; container != null; container = container.getContainer()) {
                    if (seen.add(container) && !object.equals(container)) continue;
                    return false;
                }
            }
        }
        return this.owner == null || !this.getDomain().isReadOnly((IEntity)this.owner);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.property + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (index: " + this.index + ")");
        result.append(" (affectedObjects:" + this.affectedObjects + ")");
        return result.toString();
    }
}

