/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.vocab.owl.DatatypeProperty;
import net.enilink.vocab.owl.ObjectProperty;

public class CommandParameter {
    public static final int NO_INDEX = -1;
    public Object owner;
    public Object property;
    public Collection<?> collection;
    public Object value;
    public int index;

    public CommandParameter(Object owner) {
        this.owner = owner;
    }

    public CommandParameter(Object owner, Object property, Object value) {
        this.owner = owner;
        this.property = property;
        this.value = value;
        this.index = -1;
    }

    public CommandParameter(Object owner, Object property, Object value, int index) {
        this.owner = owner;
        this.property = property;
        this.value = value;
        this.index = index;
    }

    public CommandParameter(Object owner, Object property, Collection<?> collection) {
        this.owner = owner;
        this.property = property;
        this.collection = collection;
        this.index = -1;
    }

    public CommandParameter(Object owner, Object property, Collection<?> collection, int index) {
        this.owner = owner;
        this.property = property;
        this.collection = collection;
        this.index = index;
    }

    public CommandParameter(Object owner, Object property, Object value, Collection<?> collection) {
        this.owner = owner;
        this.property = property;
        this.value = value;
        this.collection = collection;
        this.index = -1;
    }

    public CommandParameter(Object owner, Object property, Object value, Collection<?> collection, int index) {
        this.owner = owner;
        this.property = property;
        this.value = value;
        this.collection = collection;
        this.index = index;
    }

    public Object getOwner() {
        return this.owner;
    }

    public IResource getOwnerResource() {
        return this.owner instanceof IResource ? (IResource)this.owner : null;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Object getProperty() {
        return this.property;
    }

    public ObjectProperty getObjectProperty() {
        if (this.property instanceof ObjectProperty) {
            return (ObjectProperty)this.property;
        }
        if (!(this.property instanceof IResource) && this.getOwnerResource() != null && this.property instanceof IReference) {
            this.property = this.getOwnerResource().getEntityManager().find((IReference)this.property);
        }
        return this.property instanceof ObjectProperty ? (ObjectProperty)this.property : null;
    }

    public DatatypeProperty getDatatypeProperty() {
        if (this.property instanceof DatatypeProperty) {
            return (DatatypeProperty)this.property;
        }
        if (!(this.property instanceof IResource) && this.getOwnerResource() != null && this.property instanceof IReference) {
            this.property = this.getOwnerResource().getEntityManager().find((IReference)this.property);
        }
        return this.property instanceof DatatypeProperty ? (DatatypeProperty)this.property : null;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public List<?> getList() {
        return this.collection == null ? null : (this.collection instanceof List ? (List)this.collection : new ArrayList(this.collection));
    }

    public Object getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    public static String collectionToString(Collection<?> collection) {
        if (collection == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        result.append("{ ");
        Iterator<?> objects = collection.iterator();
        while (objects.hasNext()) {
            result.append(objects.next());
            if (!objects.hasNext()) continue;
            result.append(", ");
        }
        result.append(" }");
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("CommandParameter");
        result.append("\n  owner        = ");
        result.append(this.owner);
        result.append("\n  property      = ");
        result.append(this.property);
        if (this.collection != null) {
            result.append("\n  collection   = ");
            result.append(CommandParameter.collectionToString(this.collection));
        }
        if (this.value != null) {
            result.append("\n  value        = ");
            result.append(this.value);
        }
        if (this.index != -1) {
            result.append("\n  index        = ");
            result.append(this.index);
        }
        return result.toString();
    }
}

