/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CreateCopyCommand;
import net.enilink.komma.edit.command.IChildrenToCopyProvider;
import net.enilink.komma.edit.command.InitializeCopyCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class CopyCommand
extends ExtendedCompositeCommand {
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_CopyCommand_description");
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_CopyCommand_label");
    protected Helper copyHelper;
    protected IEditingDomain domain;
    protected IResource owner;

    public static ICommand create(IEditingDomain domain, Collection<?> collection, IModel targetModel) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        Helper copyHelper = new Helper(targetModel);
        ExtendedCompositeCommand copyCommand = new ExtendedCompositeCommand(Integer.MAX_VALUE);
        for (Object object : collection) {
            copyCommand.add((IUndoableOperation)domain.createCommand(CopyCommand.class, new CommandParameter(object, null, copyHelper)));
        }
        return copyCommand.reduce();
    }

    public static ICommand create(IEditingDomain domain, Object owner, IModel targetModel) {
        return domain.createCommand(CopyCommand.class, new CommandParameter(owner, null, new Helper(targetModel)));
    }

    public CopyCommand(IEditingDomain domain, IResource owner, Helper copyHelper) {
        super(LABEL, DESCRIPTION);
        this.resultIndex = 0;
        this.domain = domain;
        this.owner = owner;
        this.copyHelper = copyHelper;
        copyHelper.incrementDeferredInitializationCount();
    }

    protected void addCreateCopyCommands(ExtendedCompositeCommand compoundCommand, IResource object) {
        ICommand createCopyCommand = CreateCopyCommand.create(this.domain, object, this.copyHelper);
        compoundCommand.add((IUndoableOperation)createCopyCommand);
        if (createCopyCommand instanceof IChildrenToCopyProvider && createCopyCommand.canExecute()) {
            for (Object child : ((IChildrenToCopyProvider)createCopyCommand).getChildrenToCopy()) {
                this.addCreateCopyCommands(compoundCommand, (IResource)child);
            }
        } else {
            for (IResource child : object.getContents()) {
                this.addCreateCopyCommands(compoundCommand, child);
            }
        }
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
        if (!result.getStatus().isOK()) {
            return result;
        }
        ExtendedCompositeCommand createCommand = new ExtendedCompositeCommand(0);
        boolean transactionWasActive = this.owner.getEntityManager().getTransaction().isActive();
        if (!transactionWasActive) {
            this.owner.getEntityManager().getTransaction().begin();
            this.copyHelper.setCommitTransaction(true);
        }
        boolean rollback = false;
        try {
            this.addCreateCopyCommands(createCommand, this.owner);
            IStatus status = this.addAndExecute((ICommand)createCommand, progressMonitor, info);
            if (!status.isOK()) {
                rollback = true;
                CommandResult commandResult = CommandResult.newCommandResult((IStatus)status, null);
                return commandResult;
            }
            if (this.copyHelper.decrementDeferredInitializationCount() == 0) {
                ExtendedCompositeCommand initializeCommand = new ExtendedCompositeCommand(){

                    public boolean prepare() {
                        Iterator<IResource> copiedObjects = CopyCommand.this.copyHelper.initializationIterator();
                        while (copiedObjects.hasNext()) {
                            IResource object = copiedObjects.next();
                            ICommand initializeCopyCommand = InitializeCopyCommand.create(CopyCommand.this.domain, object, CopyCommand.this.copyHelper);
                            if (!this.appendIfCanExecute(initializeCopyCommand)) {
                                return false;
                            }
                            copiedObjects.remove();
                        }
                        return true;
                    }
                };
                status = this.addAndExecute((ICommand)initializeCommand, progressMonitor, info);
                if (this.copyHelper.getCommitTransaction()) {
                    this.owner.getEntityManager().getTransaction().commit();
                }
            }
        }
        catch (Throwable e) {
            rollback = true;
            throw new ExecutionException("Error while copying element", e);
        }
        finally {
            if (rollback && !transactionWasActive) {
                this.owner.getEntityManager().getTransaction().rollback();
            }
        }
        return CommandResult.newOKCommandResult((Object)createCommand.getCommandResult().getReturnValue());
    }

    protected boolean prepare() {
        return this.owner != null;
    }

    public Collection<Object> getAffectedResources(Object type) {
        if (IModel.class.equals(type) && this.owner instanceof IObject) {
            HashSet<Object> affected = new HashSet<Object>(super.getAffectedResources(type));
            affected.add(((IObject)this.owner).getModel());
            return affected;
        }
        return super.getAffectedResources(type);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (owner: " + this.owner + ")");
        return result.toString();
    }

    public static class Helper
    extends HashMap<IResource, IResource> {
        private static final long serialVersionUID = 1L;
        protected boolean commitTransaction;
        protected int deferredInitializationCount;
        protected List<IResource> initializationList = new ArrayList<IResource>();
        protected IModel targetModel;

        public Helper(IModel targetModel) {
            this.targetModel = targetModel;
        }

        public int decrementDeferredInitializationCount() {
            return --this.deferredInitializationCount;
        }

        public boolean getCommitTransaction() {
            return this.commitTransaction;
        }

        public IModel getTargetModel() {
            return this.targetModel;
        }

        public IResource getCopy(IReference object) {
            return (IResource)this.get(object);
        }

        public void incrementDeferredInitializationCount() {
            ++this.deferredInitializationCount;
        }

        public Iterator<IResource> initializationIterator() {
            return this.initializationList.iterator();
        }

        @Override
        public IResource put(IResource key, IResource value) {
            this.initializationList.add(key);
            return super.put(key, value);
        }

        @Override
        public IResource remove(Object key) {
            this.initializationList.remove(key);
            return (IResource)super.remove(key);
        }

        public void setCommitTransaction(boolean commitTransaction) {
            this.commitTransaction = commitTransaction;
        }
    }
}

