/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.command.IChildrenToCopyProvider;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.vocab.komma.KOMMA;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateCopyCommand
extends AbstractOverrideableCommand
implements IChildrenToCopyProvider {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_CreateCopyCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_CreateCopyCommand_description");
    protected IResource owner;
    protected IResource copy;
    protected CopyCommand.Helper copyHelper;

    public static ICommand create(IEditingDomain domain, Object owner, CopyCommand.Helper copyHelper) {
        return domain.createCommand(CreateCopyCommand.class, new CommandParameter(owner, null, copyHelper));
    }

    public CreateCopyCommand(IEditingDomain domain, IResource owner, CopyCommand.Helper copyHelper) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.copyHelper = copyHelper;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    protected boolean prepare() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Set ownerTypes = this.owner.getClasses(false).toSet();
        IModel targetModel = this.copyHelper.getTargetModel();
        if (targetModel == null && this.owner instanceof IObject) {
            targetModel = ((IObject)this.owner).getModel();
        }
        URI copyURI = null;
        if (this.owner.getURI() != null) {
            copyURI = targetModel.getURI().appendLocalPart("entity_" + UUID.randomUUID().toString());
        }
        this.copy = (IResource)targetModel.getManager().createNamed(copyURI, ownerTypes.toArray(new IReference[0]));
        this.copyHelper.put(this.owner, this.copy);
        return CommandResult.newOKCommandResult(Collections.singleton(this.copy));
    }

    @Override
    public Collection<?> doGetChildrenToCopy() {
        LinkedHashSet result = new LinkedHashSet(this.owner.getPropertyValues((IReference)KOMMA.PROPERTY_CONTAINS, true).toList());
        return result;
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && this.owner instanceof IObject) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            affected.add(((IObject)this.owner).getModel());
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }
}

