/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_DeleteCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_DeleteCommand_description");
    protected Collection<?> collection;

    public static ICommand create(IEditingDomain domain, Object object) {
        return DeleteCommand.create(domain, Collections.singleton(object));
    }

    public static ICommand create(IEditingDomain domain, Collection<?> collection) {
        return domain.createCommand(DeleteCommand.class, new CommandParameter(null, null, collection));
    }

    public DeleteCommand(IEditingDomain domain, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION);
        this.collection = collection;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    protected boolean prepare() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        LinkedHashSet<IModel> models = new LinkedHashSet<IModel>();
        LinkedHashSet<IObject> objects = new LinkedHashSet<IObject>();
        for (Object wrappedObject : this.collection) {
            Object object = AdapterFactoryEditingDomain.unwrap(wrappedObject);
            if (!(object instanceof IObject)) continue;
            models.add(((IModelAware)object).getModel());
            objects.add((IObject)object);
            LinkedList queue = new LinkedList(((IResource)object).getContents());
            while (!queue.isEmpty()) {
                IResource contentObject = (IResource)queue.remove();
                objects.add((IObject)contentObject);
                queue.addAll(contentObject.getContents());
            }
        }
        for (IModel model : models) {
            if (this.getDomain().isReadOnly(model)) continue;
            for (IObject toDelete : objects) {
                model.getManager().remove((Object)toDelete);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && this.collection != null) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            for (Object element : this.collection) {
                Object object = AdapterFactoryEditingDomain.unwrap(element);
                if (!(object instanceof IObject)) continue;
                affected.add(((IObject)object).getModel());
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }
}

