/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IMap;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.Statement;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class InitializeCopyCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_InitializeCopyCommand_description");
    protected IResource owner;
    protected IResource copy;
    protected CopyCommand.Helper copyHelper;

    public static ICommand create(IEditingDomain domain, Object owner, CopyCommand.Helper copyHelper) {
        return domain.createCommand(InitializeCopyCommand.class, new CommandParameter(owner, null, copyHelper));
    }

    public InitializeCopyCommand(IEditingDomain domain, IResource owner, CopyCommand.Helper copyHelper) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.copy = copyHelper.getCopy((IReference)owner);
        this.copyHelper = copyHelper;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public IResource getCopy() {
        return this.copy;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    protected boolean prepare() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.copyProperties();
        return CommandResult.newOKCommandResult(Collections.singleton(this.copy));
    }

    protected void copyProperties() {
        this.copy.getEntityManager().add((Iterable)this.owner.getPropertyStatements(null, false).mapWith((IMap)new IMap<IStatement, IStatement>(){

            public IStatement map(IStatement stmt) {
                Object obj = stmt.getObject();
                if (obj instanceof IReference) {
                    IResource objCopy = InitializeCopyCommand.this.copyHelper.getCopy((IReference)obj);
                    if (objCopy != null) {
                        obj = objCopy;
                    } else if (((IProperty)InitializeCopyCommand.this.copy.getEntityManager().find(stmt.getPredicate(), IProperty.class, new Class[0])).isContainment()) {
                        return null;
                    }
                }
                return new Statement((IReference)InitializeCopyCommand.this.copy, stmt.getPredicate(), obj);
            }
        }).filterKeep((Filter)new Filter<IStatement>(){

            public boolean accept(IStatement stmt) {
                return stmt != null;
            }
        }));
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.copy);
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && this.owner instanceof IObject) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            affected.add(((IObject)this.owner).getModel());
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + ")");
        result.append(" (domain: " + this.getDomain() + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (copy: " + this.copy + ")");
        result.append(" (copyHelper: " + this.copyHelper + ")");
        return result.toString();
    }
}

