/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class PasteFromClipboardCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_PasteFromClipboardCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_PasteFromClipboardCommand_description");
    protected CompositeCommand command;
    protected Object owner;
    protected Object property;
    protected int index;

    public static ICommand create(IEditingDomain domain, Object owner, Object feature) {
        return PasteFromClipboardCommand.create(domain, owner, feature, -1);
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object feature, int index) {
        if (domain == null) {
            return new PasteFromClipboardCommand(domain, owner, feature, index);
        }
        ICommand command = domain.createCommand(PasteFromClipboardCommand.class, new CommandParameter(owner, feature, Collections.emptyList(), index));
        return command;
    }

    public PasteFromClipboardCommand(IEditingDomain domain, Object owner, Object property, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = property;
        this.index = index;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getProperty() {
        return this.property;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean prepare() {
        this.command = new CompositeCommand();
        IModel targetModel = null;
        if (this.owner instanceof IObject) {
            targetModel = ((IObject)this.owner).getModel();
        } else if (this.owner instanceof IModel) {
            targetModel = (IModel)this.owner;
        }
        ICommand copyCommand = CopyCommand.create(this.getDomain(), this.getDomain().getClipboard(), targetModel);
        this.command.add((IUndoableOperation)copyCommand);
        boolean result = this.command.canExecute();
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.command.execute(progressMonitor, info);
        if (status.isOK()) {
            this.command.addAndExecute((ICommand)new CommandWrapper(){

                protected ICommand createCommand() {
                    return AddCommand.create(PasteFromClipboardCommand.this.getDomain(), PasteFromClipboardCommand.this.owner, PasteFromClipboardCommand.this.property, new ArrayList(((ICommand)PasteFromClipboardCommand.this.command.iterator().next()).getCommandResult().getReturnValues()), PasteFromClipboardCommand.this.index);
                }
            }, progressMonitor, info);
        }
        return this.command.getCommandResult();
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.command.undo(progressMonitor, info);
        return this.command.getCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.command.redo(progressMonitor, info);
        return this.command.getCommandResult();
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.command.getAffectedObjects();
    }

    @Override
    public void doDispose() {
        if (this.command != null) {
            this.command.dispose();
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.getDomain() + ")");
        return result.toString();
    }
}

