/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.change.IChangeDescription;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class RecordingWrapperCommand
extends AbstractCommand
implements AbstractCommand.INoChangeRecording {
    private IChangeDescription change;
    private ICommand command;
    private IEditingDomain domain;

    public RecordingWrapperCommand(IEditingDomain domain, ICommand command) {
        this.domain = domain;
        this.command = command;
    }

    private boolean canApplyChange() {
        return this.change == null || this.change.canUndo();
    }

    public boolean canRedo() {
        return this.canApplyChange() || this.command.canRedo();
    }

    public boolean canUndo() {
        return this.canApplyChange() || this.command.canUndo();
    }

    public void dispose() {
        super.dispose();
        this.change = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IEditingDomain.Internal internalDomain = (IEditingDomain.Internal)this.domain;
        HashSet affectedModels = new HashSet(this.command.getAffectedResources(IModel.class));
        ArrayList startedTransactions = new ArrayList(affectedModels.size());
        for (Object model : affectedModels) {
            IEntityManager modelManager = ((IModel)model).getManager();
            ITransaction transaction = modelManager.getTransaction();
            if (transaction.isActive()) continue;
        }
        boolean rollback = true;
        try {
            internalDomain.getChangeRecorder().beginRecording();
            IStatus status = this.command.execute(progressMonitor, info);
            if (status.isOK()) {
                rollback = false;
                for (ITransaction transaction : startedTransactions) {
                    if (!transaction.isActive()) continue;
                    transaction.commit();
                }
            }
            CommandResult commandResult = this.command.getCommandResult();
            return commandResult;
        }
        finally {
            this.change = internalDomain.getChangeRecorder().endRecording();
            if (rollback) {
                for (ITransaction transaction : startedTransactions) {
                    if (!transaction.isActive()) continue;
                    transaction.rollback();
                }
            }
        }
    }

    public CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.command.redo(progressMonitor, info);
        if (status.isOK() && this.change != null) {
            status = this.change.redo(progressMonitor, info);
        }
        return CommandResult.newCommandResult((IStatus)status, (Object)this.command.getCommandResult().getReturnValue());
    }

    public CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        IStatus status = this.command.undo(progressMonitor, info);
        if (status.isOK() && this.change != null) {
            status = this.change.undo(progressMonitor, info);
        }
        return CommandResult.newCommandResult((IStatus)status, (Object)this.command.getCommandResult().getReturnValue());
    }

    public Collection<?> getAffectedObjects() {
        return this.command.getAffectedObjects();
    }

    public Collection<?> getAffectedResources(Object type) {
        return this.command.getAffectedResources(type);
    }

    public String getDescription() {
        return this.command.getDescription();
    }

    public String getLabel() {
        return this.command.getLabel();
    }

    protected boolean prepare() {
        return this.command.canExecute();
    }
}

