/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemoveCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_RemoveCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_RemoveCommand_description");
    protected static final String DESCRIPTION_FOR_LIST = KommaEditPlugin.INSTANCE.getString("_UI_RemoveCommand_description_for_list");
    protected IResource owner;
    protected IReference property;
    protected Collection<Object> ownerList;
    protected Collection<Object> collection;
    protected int[] indices;
    protected Collection<?> affectedObjects;

    public static ICommand create(IEditingDomain domain, Object value) {
        return RemoveCommand.create(domain, Collections.singleton(value));
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Object value) {
        return RemoveCommand.create(domain, owner, property, Collections.singleton(value));
    }

    public static ICommand create(IEditingDomain domain, Collection<?> collection) {
        return RemoveCommand.create(domain, null, null, collection);
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Collection<?> collection) {
        return domain.createCommand(RemoveCommand.class, new CommandParameter(owner, property, collection));
    }

    public RemoveCommand(IEditingDomain domain, IResource owner, IReference property, Object value) {
        this(domain, owner, property, Collections.singleton(value));
    }

    public RemoveCommand(IEditingDomain domain, IResource owner, IReference property, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = property;
        this.collection = collection == null ? null : new ArrayList(collection);
        this.ownerList = RemoveCommand.getOwnerList(this.owner, property);
    }

    public RemoveCommand(IEditingDomain domain, Collection<?> list, Object value) {
        this(domain, list, Collections.singleton(value));
    }

    public RemoveCommand(IEditingDomain domain, Collection<?> list, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION_FOR_LIST);
        this.collection = collection == null ? null : new ArrayList(collection);
        Collection<?> untypedList = list;
        this.ownerList = untypedList;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public IReference getProperty() {
        return this.property;
    }

    public Collection<Object> getOwnerList() {
        return this.ownerList;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public int[] getIndices() {
        return this.indices;
    }

    protected boolean prepare() {
        boolean result = (this.ownerList != null && this.collection != null && this.ownerList.containsAll(this.collection) || this.ownerList == null && this.owner != null && this.collection.size() == 1 && this.owner.hasProperty(this.property, this.collection.iterator().next(), false)) && (this.owner == null || !this.getDomain().isReadOnly((IEntity)this.owner));
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        boolean transactionWasActive = true;
        if (this.owner != null && !(transactionWasActive = this.owner.getEntityManager().getTransaction().isActive())) {
            this.owner.getEntityManager().getTransaction().begin();
        }
        try {
            if (this.ownerList != null) {
                if (this.ownerList instanceof List) {
                    this.indices = new int[this.collection.size()];
                    int i = 0;
                    for (Object obj : this.collection) {
                        this.indices[i++] = ((List)this.ownerList).indexOf(obj);
                    }
                }
                this.ownerList.removeAll(this.collection);
            } else {
                this.owner.removeProperty(this.property, this.collection.iterator().next());
            }
            Set<IResource> set = this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
            if (!transactionWasActive) {
                this.owner.getEntityManager().getTransaction().commit();
            }
        }
        catch (Throwable e) {
            if (!transactionWasActive) {
                this.owner.getEntityManager().getTransaction().rollback();
            }
            throw new ExecutionException("Error while removing element", e);
        }
        return CommandResult.newOKCommandResult(this.collection);
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doUndoWithResult(progressMonitor, info);
        this.affectedObjects = this.collection;
        return result;
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doRedoWithResult(progressMonitor, info);
        this.affectedObjects = this.owner == null ? Collections.EMPTY_SET : Collections.singleton(this.owner);
        return result;
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && (this.owner != null || this.ownerList != null || this.collection != null)) {
            Object object;
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            if (this.owner instanceof IObject) {
                affected.add(((IObject)this.owner).getModel());
            }
            if (this.ownerList != null) {
                for (Object element : this.ownerList) {
                    object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            if (this.collection != null) {
                for (Object element : this.collection) {
                    object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.affectedObjects;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (property: " + this.property + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (indices: " + Arrays.toString(this.indices) + ")");
        result.append(" (affectedObjects: " + this.affectedObjects + ")");
        return result.toString();
    }
}

