/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.vocab.rdf.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReplaceCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_ReplaceCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_ReplaceCommand_description");
    protected IResource owner;
    protected IReference property;
    protected Collection<Object> ownerList;
    protected Object value;
    protected Collection<?> collection;
    protected Collection<?> affectedObjects;

    public static ICommand create(IEditingDomain domain, Object value, Collection<?> collection) {
        return ReplaceCommand.create(domain, null, null, value, collection);
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object feature, Object value, Collection<?> collection) {
        return domain.createCommand(ReplaceCommand.class, new CommandParameter(owner, feature, value, collection));
    }

    public ReplaceCommand(IEditingDomain domain, IResource owner, IReference feature, Object value, Object replacement) {
        this(domain, owner, feature, value, Collections.singleton(replacement));
    }

    public ReplaceCommand(IEditingDomain domain, IResource owner, IReference feature, Object value, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = feature;
        this.value = value;
        this.collection = collection;
        this.ownerList = ReplaceCommand.getOwnerList(this.owner, feature);
    }

    public ReplaceCommand(IEditingDomain domain, Collection<?> list, Object value, Object replacement) {
        this(domain, list, value, Collections.singleton(replacement));
    }

    public ReplaceCommand(IEditingDomain domain, Collection<?> list, Object value, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION);
        this.value = value;
        this.collection = collection;
        Collection<?> untypedList = list;
        this.ownerList = untypedList;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public IReference getProperty() {
        return this.property;
    }

    public Collection<Object> getOwnerList() {
        return this.ownerList;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    protected boolean prepare() {
        if (this.ownerList == null || !this.ownerList.contains(this.value) || this.collection == null || this.collection.isEmpty()) {
            return false;
        }
        if (this.owner != null && this.getDomain().isReadOnly((IEntity)this.owner)) {
            return false;
        }
        if (this.property == null) {
            return true;
        }
        if (this.owner != null && this.property != null) {
            IProperty property = (IProperty)this.owner.getEntityManager().find(this.property);
            for (Object replacement : this.collection) {
                if (property.isRangeCompatible(replacement)) continue;
                return false;
            }
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        int index = -1;
        if (this.ownerList instanceof List) {
            index = ((List)this.ownerList).indexOf(this.value);
        }
        this.ownerList.remove(this.value);
        if (index != -1 && this.ownerList instanceof List) {
            ((List)this.ownerList).addAll(index, this.collection);
        } else {
            this.ownerList.addAll(this.collection);
        }
        this.affectedObjects = this.collection;
        return CommandResult.newOKCommandResult(this.collection);
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.affectedObjects;
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && (this.owner != null || this.ownerList != null || this.collection != null)) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            if (this.value instanceof IObject) {
                affected.add(((IObject)this.value).getModel());
            }
            if (this.owner instanceof IObject) {
                affected.add(((IObject)this.owner).getModel());
            }
            if (this.ownerList != null) {
                for (Object element : this.ownerList) {
                    Object object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (property: " + this.property + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (value: " + this.value + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (affectedObjects:" + this.affectedObjects + ")");
        return result.toString();
    }
}

