/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.IdentityCommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.MoveCommand;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.vocab.owl.InverseFunctionalProperty;
import net.enilink.vocab.owl.ObjectProperty;
import net.enilink.vocab.rdf.Property;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetCommand
extends AbstractOverrideableCommand {
    public static final Object UNSET_VALUE = new Object();
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_SetCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_SetCommand_description");
    protected IResource owner;
    protected IReference property;
    protected Collection<Object> ownerList;
    protected Object value;
    protected Object oldValue;
    protected int index;
    protected boolean canUndo = true;
    protected ICommand removeCommand;

    public static ICommand create(IEditingDomain domain, Object owner, Object feature, Object value) {
        return SetCommand.create(domain, owner, feature, value, -1);
    }

    public static ICommand create(IEditingDomain domain, final Object owner, Object property, Object value, int index) {
        if (owner instanceof IResource && property != null && ((IResource)owner).hasApplicableProperty((IReference)property) && (Integer)((IResource)owner).getApplicableCardinality((IReference)property).getSecond() != 1 && index == -1) {
            List values = value == UNSET_VALUE ? Collections.EMPTY_LIST : (List)value;
            Collection oldValues = (Collection)((IResource)owner).get((IReference)property);
            ExtendedCompositeCommand compound = null;
            compound = new ExtendedCompositeCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                public Collection<?> getAffectedObjects() {
                    return Collections.singleton(owner);
                }
            };
            if (!oldValues.isEmpty()) {
                if (!values.isEmpty()) {
                    HashSet removedValues = new HashSet(oldValues);
                    removedValues.removeAll(values);
                    if (!removedValues.equals(oldValues)) {
                        if (!removedValues.isEmpty()) {
                            compound.add((IUndoableOperation)RemoveCommand.create(domain, owner, property, new HashSet(removedValues)));
                        }
                        ArrayList remainingValues = new ArrayList(oldValues);
                        remainingValues.removeAll(removedValues);
                        int count = -1;
                        for (Object object : values) {
                            int position = remainingValues.indexOf(object);
                            if (position == -1 || position == ++count) continue;
                            compound.add((IUndoableOperation)MoveCommand.create(domain, owner, property, object, count));
                        }
                        HashSet addedValues = new HashSet(values);
                        addedValues.removeAll(remainingValues);
                        ListIterator i = values.listIterator();
                        while (i.hasNext()) {
                            Object object = i.next();
                            if (!addedValues.contains(object)) continue;
                            int addIndex = i.previousIndex();
                            if (addIndex > oldValues.size()) {
                                addIndex = -1;
                            }
                            compound.add((IUndoableOperation)AddCommand.create(domain, owner, property, object, addIndex));
                        }
                        return compound;
                    }
                }
                compound.add((IUndoableOperation)RemoveCommand.create(domain, owner, property, new HashSet(oldValues)));
            }
            if (!values.isEmpty()) {
                compound.add((IUndoableOperation)AddCommand.create(domain, owner, property, values));
            } else if (value == UNSET_VALUE) {
                compound.add((IUndoableOperation)domain.createCommand(SetCommand.class, new CommandParameter(owner, property, value)));
            } else if (compound.getCommandList().isEmpty()) {
                return IdentityCommand.INSTANCE;
            }
            return compound;
        }
        return domain.createCommand(SetCommand.class, new CommandParameter(owner, property, value, index));
    }

    public SetCommand(IEditingDomain domain, IResource owner, IReference feature, Object value) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = feature;
        this.value = value;
        this.index = -1;
    }

    public SetCommand(IEditingDomain domain, IResource owner, IReference feature, Object value, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = feature;
        this.value = value;
        this.index = index;
        if (index != -1) {
            this.ownerList = SetCommand.getOwnerList(owner, feature);
        }
    }

    public IResource getOwner() {
        return this.owner;
    }

    public IReference getProperty() {
        return this.property;
    }

    public Collection<Object> getOwnerList() {
        return this.ownerList;
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    protected boolean prepare() {
        boolean result = false;
        if (this.owner != null) {
            if (this.getDomain().isReadOnly((IEntity)this.owner) || this.property == null) {
                return false;
            }
            IProperty resolvedProperty = (IProperty)this.owner.getEntityManager().find(this.property);
            if (this.ownerList != null) {
                if (this.index >= 0 && this.ownerList instanceof List && this.index < this.ownerList.size() && resolvedProperty.isRangeCompatible(this.value) && (!(resolvedProperty instanceof InverseFunctionalProperty) || !this.ownerList.contains(this.value))) {
                    this.oldValue = ((List)this.ownerList).get(this.index);
                    result = true;
                }
            } else if (resolvedProperty.isMany((IReference)this.owner)) {
                this.oldValue = this.owner.isPropertySet(this.property, true) ? this.owner.get(this.property) : UNSET_VALUE;
                if (this.value == UNSET_VALUE) {
                    result = true;
                } else if (this.value instanceof Collection) {
                    Collection collection = (Collection)this.value;
                    result = true;
                    if (!resolvedProperty.hasListRange()) {
                        for (Object object : collection) {
                            if (resolvedProperty.isRangeCompatible(object)) continue;
                            result = false;
                            break;
                        }
                    }
                }
            } else {
                this.oldValue = this.owner.isPropertySet(this.property, true) ? this.owner.get(this.property) : UNSET_VALUE;
                boolean bl = result = this.value == null || this.value == UNSET_VALUE || resolvedProperty.isRangeCompatible(this.value);
            }
            if (result && this.value != null && resolvedProperty instanceof ObjectProperty && resolvedProperty.isContainment()) {
                HashSet<IResource> seen = new HashSet<IResource>();
                for (IResource container = this.owner; container != null; container = container.getContainer()) {
                    if (seen.add(container) && !this.value.equals(container)) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.property = this.owner.getEntityManager().find(this.property);
        if (this.property instanceof ObjectProperty && !((ObjectProperty)this.property).getOwlInverseOf().isEmpty()) {
            if (this.oldValue instanceof Collection) {
                this.oldValue = new ArrayList((Collection)this.owner.get(this.property));
            } else if (this.oldValue != UNSET_VALUE && this.index == -1) {
                this.oldValue = this.owner.get(this.property);
            }
            for (Property otherProperty : ((ObjectProperty)this.property).getOwlInverseOf()) {
                IResource eObject;
                IResource otherEObject;
                ExtendedCompositeCommand compoundCommand;
                if (this.oldValue instanceof IResource && ((IProperty)otherProperty).isMany((IReference)((IResource)this.oldValue))) {
                    Collection oldValues;
                    if (this.oldValue instanceof Collection && (oldValues = (Collection)this.oldValue) != null && !oldValues.isEmpty()) {
                        compoundCommand = new ExtendedCompositeCommand();
                        for (IResource oldValueObject : oldValues) {
                            compoundCommand.appendIfCanExecute((ICommand)new RemoveCommand(this.getDomain(), oldValueObject, (IReference)otherProperty, this.owner));
                        }
                        this.removeCommand = compoundCommand;
                    }
                } else if (this.value instanceof Collection) {
                    Collection newValues = (Collection)this.value;
                    if (!newValues.isEmpty()) {
                        compoundCommand = new ExtendedCompositeCommand();
                        for (IResource newValueObject : newValues) {
                            compoundCommand.appendIfCanExecute((ICommand)new SetCommand(this.getDomain(), newValueObject, (IReference)otherProperty, UNSET_VALUE));
                            IResource otherObject = (IResource)newValueObject.get((IReference)otherProperty);
                            if (otherObject == null) continue;
                            compoundCommand.appendIfCanExecute((ICommand)new SetCommand(this.getDomain(), newValueObject, (IReference)otherProperty, UNSET_VALUE));
                        }
                        this.removeCommand = compoundCommand;
                    }
                } else if (this.value instanceof IResource && (otherEObject = (IResource)(eObject = (IResource)this.value).get((IReference)otherProperty)) != null) {
                    this.removeCommand = new SetCommand(this.getDomain(), eObject, (IReference)otherProperty, UNSET_VALUE);
                }
                if (this.removeCommand == null) continue;
                if (this.removeCommand.canExecute()) {
                    this.removeCommand.execute(progressMonitor, info);
                    continue;
                }
                this.removeCommand = null;
            }
        }
        if (this.ownerList instanceof List) {
            if (this.removeCommand == null || this.ownerList.size() > this.index && ((List)this.ownerList).get(this.index) == this.oldValue) {
                ((List)this.ownerList).set(this.index, this.value);
            } else {
                ((List)this.ownerList).add(this.index, this.value);
            }
        } else if (this.value == UNSET_VALUE) {
            this.owner.removeProperty(this.property);
        } else {
            this.owner.set(this.property, this.value);
        }
        return CommandResult.newOKCommandResult(Collections.singleton(this.owner));
    }

    @Override
    public boolean doCanUndo() {
        return this.canUndo;
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && (this.owner != null || this.ownerList != null)) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            if (this.owner instanceof IObject) {
                affected.add(((IObject)this.owner).getModel());
            }
            if (this.ownerList != null) {
                for (Object element : this.ownerList) {
                    Object object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.property + ")");
        if (this.ownerList != null) {
            result.append(" (ownerList: " + this.ownerList + ")");
            result.append(" (index: " + this.index + ")");
        }
        result.append(" (value: " + this.value + ")");
        result.append(" (oldValue: " + this.oldValue + ")");
        return result.toString();
    }
}

