/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.domain;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import net.enilink.komma.common.adapter.IAdapter;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.ICommandStack;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.common.util.AbstractTreeIterator;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.common.util.ITreeIterator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyToClipboardCommand;
import net.enilink.komma.edit.command.CreateChildCommand;
import net.enilink.komma.edit.command.CutToClipboardCommand;
import net.enilink.komma.edit.command.DeleteCommand;
import net.enilink.komma.edit.command.IOverrideableCommand;
import net.enilink.komma.edit.command.PasteFromClipboardCommand;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.command.ReplaceCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomainProvider;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IWrapperItemProvider;
import net.enilink.komma.edit.provider.ItemProviderAdapter;
import net.enilink.komma.em.util.UnitOfWork;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IModelSetFactory;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelSetModule;
import net.enilink.komma.model.change.ChangeRecorder;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;

public class AdapterFactoryEditingDomain
implements IEditingDomain,
IEditingDomain.Internal {
    protected IAdapterFactory adapterFactory;
    protected Collection<Object> clipboard;
    protected ICommandStack commandStack;
    protected IModelSet modelSet;
    protected Map<IModel, Boolean> modelToReadOnlyMap;
    private EditingDomainProviderAdapter domainProvider;
    private ChangeRecorder recorder;
    private IModelSet clipboardModelSet;

    public static IEditingDomain getEditingDomainFor(Object object) {
        if (object instanceof IEditingDomainProvider) {
            IEditingDomain editingDomain = ((IEditingDomainProvider)object).getEditingDomain();
            return editingDomain;
        }
        if (object instanceof IWrapperItemProvider) {
            return AdapterFactoryEditingDomain.getEditingDomainFor(((IWrapperItemProvider)object).getValue());
        }
        IEditingDomainProvider provider = null;
        if (object instanceof IObject) {
            provider = (IEditingDomainProvider)((IObject)object).getModel().getModelSet().adapters().getAdapter(IEditingDomainProvider.class);
        } else if (object instanceof IAdaptable) {
            provider = (IEditingDomainProvider)((IAdaptable)object).getAdapter(IEditingDomainProvider.class);
        }
        if (provider != null) {
            return provider.getEditingDomain();
        }
        return null;
    }

    public static boolean isStale(Object object) {
        if (object instanceof IWrapperItemProvider) {
            IWrapperItemProvider wrapper = (IWrapperItemProvider)object;
            return AdapterFactoryEditingDomain.isStale(wrapper.getValue()) || AdapterFactoryEditingDomain.isStale(wrapper.getOwner());
        }
        if (object instanceof Collection) {
            for (Object item : (Collection)object) {
                if (!AdapterFactoryEditingDomain.isStale(item)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Object[]) {
            for (Object item : (Object[])object) {
                if (!AdapterFactoryEditingDomain.isStale(item)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof IEntity) {
            return ((IEntity)object).getEntityManager() == null || !((IEntity)object).getEntityManager().isOpen();
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        try {
            Method method = objectClass.getMethod("toArray", new Class[0]);
            return AdapterFactoryEditingDomain.isStale(method.invoke(object, new Object[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object unwrap(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getValue();
        }
        return object;
    }

    public AdapterFactoryEditingDomain(IAdapterFactory adapterFactory, ICommandStack commandStack, IModelSet modelSet) {
        this.adapterFactory = adapterFactory;
        this.commandStack = commandStack;
        this.modelSet = modelSet;
        this.registerDomainProviderAdapter();
        this.initialize();
    }

    protected void registerDomainProviderAdapter() {
        this.domainProvider = new EditingDomainProviderAdapter();
        this.modelSet.adapters().add((Object)this.domainProvider);
    }

    protected ChangeRecorder createChangeRecorder(IModelSet modelSet) {
        return new ChangeRecorder(modelSet);
    }

    @Override
    public ICommand createCommand(Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
        Object owner = commandParameter.getOwner();
        if (commandClass == CopyToClipboardCommand.class) {
            return new CopyToClipboardCommand((IEditingDomain)this, commandParameter.getCollection());
        }
        if (commandClass == PasteFromClipboardCommand.class) {
            return new PasteFromClipboardCommand(this, commandParameter.getOwner(), commandParameter.getProperty(), commandParameter.getIndex());
        }
        if (commandClass == CutToClipboardCommand.class) {
            return new CutToClipboardCommand(this, RemoveCommand.create((IEditingDomain)this, commandParameter.getOwner(), commandParameter.getProperty(), commandParameter.getCollection()));
        }
        if (commandClass == DeleteCommand.class) {
            return new DeleteCommand((IEditingDomain)this, commandParameter.getCollection());
        }
        if (owner != null) {
            IEditingDomainItemProvider editingDomainItemProvider = (IEditingDomainItemProvider)this.adapterFactory.adapt(owner, IEditingDomainItemProvider.class);
            return editingDomainItemProvider != null ? editingDomainItemProvider.createCommand(owner, this, commandClass, commandParameter) : new ItemProviderAdapter(null).createCommand(owner, this, commandClass, commandParameter);
        }
        if (commandClass == RemoveCommand.class) {
            ExtendedCompositeCommand removeCommand = new ExtendedCompositeCommand(Integer.MAX_VALUE);
            ArrayList objects = new ArrayList(commandParameter.getCollection());
            while (!objects.isEmpty()) {
                ListIterator remainingObjects = objects.listIterator();
                Object object = remainingObjects.next();
                remainingObjects.remove();
                Object parent = this.getParent(object);
                if (parent != null) {
                    ArrayList siblings = new ArrayList();
                    siblings.add(object);
                    while (remainingObjects.hasNext()) {
                        Object otherObject = remainingObjects.next();
                        Object otherParent = this.getParent(otherObject);
                        if (otherParent != parent) continue;
                        remainingObjects.remove();
                        siblings.add(otherObject);
                    }
                    removeCommand.add((IUndoableOperation)this.createCommand(RemoveCommand.class, new CommandParameter(parent, null, siblings)));
                    continue;
                }
                if (object == null) continue;
                removeCommand.add((IUndoableOperation)this.createCommand(RemoveCommand.class, new CommandParameter(object, null, Collections.singleton(object))));
            }
            return removeCommand.reduce();
        }
        if (commandClass == ReplaceCommand.class) {
            Object parent;
            Object obj = commandParameter.getValue();
            Object object = parent = obj == null ? null : this.getParent(obj);
            if (parent == null) {
                parent = obj;
            }
            return this.createCommand(ReplaceCommand.class, new CommandParameter(parent, null, obj, commandParameter.getCollection()));
        }
        if (commandClass == CreateChildCommand.class) {
            Object parent;
            Collection<?> sel = commandParameter.getCollection();
            Object object = parent = sel == null ? null : this.getParent(sel.iterator().next());
            if (parent == null) {
                return UnexecutableCommand.INSTANCE;
            }
            return this.createCommand(CreateChildCommand.class, new CommandParameter(parent, commandParameter.getProperty(), commandParameter.getValue(), commandParameter.getCollection(), commandParameter.getIndex()));
        }
        try {
            Constructor<? extends ICommand> constructor = commandClass.getConstructor(IEditingDomain.class, CommandParameter.class);
            ICommand command = constructor.newInstance(this, commandParameter);
            return command;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public ICommand createOverrideCommand(IOverrideableCommand command) {
        return null;
    }

    @Override
    public void dispose() {
        if (this.recorder != null) {
            this.recorder.dispose();
            this.recorder = null;
        }
        if (this.domainProvider != null) {
            this.modelSet.adapters().remove((Object)this.domainProvider);
            this.domainProvider = null;
        }
    }

    public IAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public ChangeRecorder getChangeRecorder() {
        return this.recorder;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        IEditingDomainItemProvider editingDomainItemProvider = (IEditingDomainItemProvider)this.adapterFactory.adapt(object, IEditingDomainItemProvider.class);
        return editingDomainItemProvider != null ? editingDomainItemProvider.getChildren(object) : Collections.emptyList();
    }

    @Override
    public Collection<Object> getClipboard() {
        return this.clipboard;
    }

    @Override
    public synchronized IModel getClipboardModel() {
        IModel model;
        if (this.clipboardModelSet == null) {
            IModelSetFactory factory = (IModelSetFactory)Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new ModelSetModule(ModelPlugin.createModelSetModule((ClassLoader)this.getClass().getClassLoader()))}).with(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(UnitOfWork.class).toInstance((Object)((UnitOfWork)AdapterFactoryEditingDomain.this.getModelSet().getUnitOfWork()));
                    this.bind(IUnitOfWork.class).toInstance((Object)AdapterFactoryEditingDomain.this.getModelSet().getUnitOfWork());
                }
            }})}).getInstance(IModelSetFactory.class);
            this.clipboardModelSet = factory.createModelSet(new URI[]{URIs.createURI((String)"http://enilink.net/vocab/komma/models#MemoryModelSet")});
        }
        if ((model = this.clipboardModelSet.getModel(URIs.createURI((String)"clipboard:///"), false)) != null) {
            return model;
        }
        return this.clipboardModelSet.createModel(URIs.createURI((String)"clipboard:///"));
    }

    @Override
    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    @Override
    public IModelSet getModelSet() {
        return this.modelSet;
    }

    public Map<IModel, Boolean> getModelToReadOnlyMap() {
        return this.modelToReadOnlyMap;
    }

    @Override
    public void getNewChildDescriptors(Object object, Object sibling, ICollector<Object> descriptors) {
        if (object == null) {
            object = this.getParent(sibling);
        }
        if (object == null) {
            return;
        }
        IEditingDomainItemProvider editingDomainItemProvider = (IEditingDomainItemProvider)this.adapterFactory.adapt(object, IEditingDomainItemProvider.class);
        if (editingDomainItemProvider != null) {
            editingDomainItemProvider.getNewChildDescriptors(object, this, sibling, descriptors);
        }
    }

    @Override
    public Object getParent(Object object) {
        IEditingDomainItemProvider editingDomainItemProvider = (IEditingDomainItemProvider)this.adapterFactory.adapt(object, IEditingDomainItemProvider.class);
        return editingDomainItemProvider != null ? editingDomainItemProvider.getParent(object) : null;
    }

    public Object getRoot(Object object) {
        Object result = object;
        Object parent = this.getParent(object);
        while (parent != null) {
            result = parent;
            parent = this.getParent(parent);
        }
        return result;
    }

    public Object getWrapper(Object object) {
        if (object != null) {
            ITreeIterator<?> i = this.treeIterator(this.getRoot(object));
            while (i.hasNext()) {
                Object element;
                Object elementValue = element = i.next();
                while (elementValue instanceof IWrapperItemProvider) {
                    elementValue = ((IWrapperItemProvider)elementValue).getValue();
                }
                if (elementValue != object) continue;
                return element;
            }
        }
        return object;
    }

    protected void initialize() {
        this.recorder = this.createChangeRecorder(this.modelSet);
    }

    @Override
    public boolean isReadOnly(IModel model) {
        if (this.modelToReadOnlyMap == null) {
            return false;
        }
        Boolean result = this.modelToReadOnlyMap.get(model);
        if (result == null && model != null) {
            Map attributes = (model.getModelSet() == null ? this.modelSet : model.getModelSet()).getURIConverter().getAttributes(model.getURI(), null);
            result = Boolean.TRUE.equals(attributes.get("readOnly"));
            this.modelToReadOnlyMap.put(model, result);
        }
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean isReadOnly(IEntity entity) {
        if (!(entity instanceof IObject)) {
            return false;
        }
        return this.isReadOnly(((IObject)entity).getModel());
    }

    public void setAdapterFactory(IAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    @Override
    public void setClipboard(Collection<Object> clipboard) {
        this.clipboard = clipboard;
    }

    public void setModelToReadOnlyMap(Map<IModel, Boolean> modelToReadOnlyMap) {
        this.modelToReadOnlyMap = modelToReadOnlyMap;
    }

    public ITreeIterator<?> treeIterator(Object object) {
        return new DomainTreeIterator<Object>(this, object);
    }

    private class EditingDomainProviderAdapter
    implements IAdapter,
    IEditingDomainProvider {
        private EditingDomainProviderAdapter() {
        }

        public void addTarget(Object adapted) {
        }

        public boolean isAdapterForType(Object type) {
            return IEditingDomainProvider.class.equals(type);
        }

        public void removeTarget(Object adapted) {
        }

        @Override
        public IEditingDomain getEditingDomain() {
            return AdapterFactoryEditingDomain.this;
        }
    }

    public static class DomainTreeIterator<E>
    extends AbstractTreeIterator<E> {
        private static final long serialVersionUID = 1L;
        protected IEditingDomain domain;

        public DomainTreeIterator(IEditingDomain domain, E object) {
            super(object);
            this.domain = domain;
        }

        public DomainTreeIterator(IEditingDomain domain, Object object, boolean includeRoot) {
            super(object, includeRoot);
            this.domain = domain;
        }

        protected Iterator<E> getChildren(Object o) {
            return this.domain.getChildren(o).iterator();
        }
    }
}

