/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.properties;

import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.properties.IEditingSupport;
import net.enilink.komma.edit.properties.IProposalSupport;
import net.enilink.komma.edit.properties.LiteralEditingSupport;
import net.enilink.komma.edit.properties.LiteralLangTypeEditingSupport;
import net.enilink.komma.edit.properties.ManchesterEditingSupport;
import net.enilink.komma.edit.properties.ResourceEditingSupport;
import net.enilink.komma.edit.util.PropertyUtil;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.vocab.owl.DatatypeProperty;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdfs.RDFS;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public abstract class EditingHelper {
    public static URI NULL_URI = URIs.createURI((String)"komma:null");
    protected IAdapterFactory delegatingAdapterFactory = new IAdapterFactory(){

        public Object adapt(Object object, Object type) {
            IAdapterFactory factory = EditingHelper.this.getAdapterFactory();
            return factory == null ? null : EditingHelper.this.getAdapterFactory().adapt(object, type);
        }

        public boolean isFactoryForType(Object type) {
            IAdapterFactory factory = EditingHelper.this.getAdapterFactory();
            return factory == null ? false : EditingHelper.this.getAdapterFactory().isFactoryForType(type);
        }
    };
    protected final Type type;

    public EditingHelper(Type type) {
        this.type = type;
    }

    public boolean canEdit(Object element) {
        if (this.type == Type.PROPERTY) {
            return element instanceof IStatement && ((IStatement)element).getObject() == null;
        }
        if (element instanceof IStatement && (((IStatement)element).getPredicate() == null || ((IStatement)element).isInferred())) {
            return false;
        }
        IEditingSupport editingSupport = this.getEditingSupport(element);
        if (editingSupport != null) {
            return editingSupport.canEdit(element);
        }
        return false;
    }

    protected IAdapterFactory getAdapterFactory() {
        IEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected abstract IEditingDomain getEditingDomain();

    protected IEditingSupport getEditingSupport(Object element) {
        if (element instanceof IStatement) {
            IStatement stmt = (IStatement)element;
            if (this.type == Type.PROPERTY) {
                return new ResourceEditingSupport(this.delegatingAdapterFactory, true);
            }
            if (this.type == Type.LITERAL_LANG_TYPE) {
                return new LiteralLangTypeEditingSupport(this.delegatingAdapterFactory);
            }
            return this.getEditingSupport(this.delegatingAdapterFactory, (IEntity)stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
        }
        return null;
    }

    public IProposalSupport getProposalSupport(Object element) {
        IEditingSupport editingSupport = this.getEditingSupport(element);
        if (editingSupport != null) {
            return editingSupport.getProposalSupport(element);
        }
        return null;
    }

    public Object getValue(Object element) {
        IEditingSupport editingSupport = this.getEditingSupport(element);
        if (editingSupport != null) {
            return editingSupport.getEditorValue(element);
        }
        return null;
    }

    protected void setProperty(Object element, IProperty property) {
    }

    protected Object unwrap(Object element) {
        if (element instanceof IStatement) {
            IStatement stmt = (IStatement)element;
            return new Statement(stmt.getSubject(), stmt.getPredicate(), this.unwrap(stmt.getObject()));
        }
        return NULL_URI.equals(element) || element instanceof ILiteral && NULL_URI.equals((Object)((ILiteral)element).getDatatype()) ? null : element;
    }

    public CommandResult setValue(Object element, IEntityManager entityManager, Object value) {
        if (value == null || !(value instanceof IResource) && value.equals(this.getValue(element))) {
            return CommandResult.newOKCommandResult();
        }
        IEditingSupport editingSupport = this.getEditingSupport(element);
        if (editingSupport == null) {
            return CommandResult.newCancelledCommandResult();
        }
        ICommand newObjectCommand = editingSupport.convertEditorValue(value, entityManager, this.unwrap(element));
        if (this.type == Type.PROPERTY && newObjectCommand != null) {
            try {
                newObjectCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                return CommandResult.newErrorCommandResult((Throwable)e);
            }
            Object newPredicate = newObjectCommand.getCommandResult().getReturnValue();
            if (newPredicate instanceof IProperty) {
                this.setProperty(element, (IProperty)newPredicate);
            }
            return CommandResult.newOKCommandResult();
        }
        if (newObjectCommand != null) {
            CommandResult result;
            if (element instanceof IStatement) {
                final IStatement stmt = (IStatement)this.unwrap(element);
                CompositeCommand command = new CompositeCommand(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        IResource subject = (IResource)stmt.getSubject();
                        ITransaction transaction = subject.getEntityManager().getTransaction();
                        transaction.begin();
                        try {
                            IStatus status;
                            CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                            if (!result.getStatus().isOK()) {
                                CommandResult commandResult = result;
                                return commandResult;
                            }
                            transaction.commit();
                            transaction.begin();
                            IProperty predicate = (IProperty)subject.getEntityManager().find(stmt.getPredicate(), IProperty.class, new Class[0]);
                            Object obj = stmt.getObject();
                            int index = -1;
                            if (obj == null) {
                                status = Status.OK_STATUS;
                            } else {
                                ICommand removeCmd = PropertyUtil.getRemoveCommand(EditingHelper.this.getEditingDomain(), (IResource)stmt.getSubject(), predicate, obj);
                                status = this.addAndExecute(removeCmd, progressMonitor, info);
                                index = PropertyUtil.getRemovedIndex((IUndoableOperation)removeCmd);
                            }
                            Object returnValue2 = null;
                            if (status.isOK() && !result.getReturnValues().isEmpty()) {
                                for (Object returnValue2 : result.getReturnValues()) {
                                }
                                status = this.addAndExecute(PropertyUtil.getAddCommand(EditingHelper.this.getEditingDomain(), subject, predicate, returnValue2, index), progressMonitor, info);
                            }
                            if (status.isOK()) {
                                transaction.commit();
                            }
                            CommandResult commandResult = new CommandResult(status, returnValue2);
                            return commandResult;
                        }
                        finally {
                            if (transaction.isActive()) {
                                transaction.rollback();
                            }
                        }
                    }
                };
                command.add((IUndoableOperation)newObjectCommand);
                result = this.execute((ICommand)command);
            } else {
                result = this.execute(newObjectCommand);
            }
            return result == null ? CommandResult.newOKCommandResult() : result;
        }
        return CommandResult.newCancelledCommandResult();
    }

    protected CommandResult execute(ICommand command) {
        try {
            this.getEditingDomain().getCommandStack().execute(command, null, null);
            return command.getCommandResult();
        }
        catch (Exception exc) {
            return CommandResult.newErrorCommandResult((Throwable)exc);
        }
    }

    public IEditingSupport getEditingSupport(IAdapterFactory adapterFactory, IEntity subject, IReference predicate, Object object) {
        IEditingSupport support;
        IEditingSupport iEditingSupport = support = adapterFactory == null ? null : (IEditingSupport)adapterFactory.adapt((Object)predicate, IEditingSupport.class);
        if (support != null) {
            return support;
        }
        if (object != null && !(object instanceof IReference)) {
            support = new LiteralEditingSupport();
        }
        if (support == null) {
            IProperty property;
            IProperty iProperty = property = predicate instanceof IProperty ? (IProperty)predicate : (IProperty)subject.getEntityManager().find(predicate, IProperty.class, new Class[0]);
            support = property instanceof DatatypeProperty || property.getRdfsRanges().contains(RDFS.TYPE_LITERAL) || ((IQuery)property.getEntityManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> ASK { ?p rdfs:range ?r . filter (exists { ?r a rdfs:DataType } || regex(str(?r), 'http://www.w3.org/2001/XMLSchema#')) }").setParameter("p", (Object)property)).getBooleanResult() ? new LiteralEditingSupport() : (object instanceof IClass || property.getRdfsRanges().contains(RDFS.TYPE_CLASS) || property.getRdfsRanges().contains(OWL.TYPE_CLASS) ? new ManchesterEditingSupport(adapterFactory) : new ResourceEditingSupport(adapterFactory));
        }
        return support;
    }

    public static enum Type {
        PROPERTY,
        VALUE,
        LITERAL_LANG_TYPE;

    }
}

