/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.SimpleCommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.assist.IContentProposal;
import net.enilink.komma.edit.assist.IContentProposalProvider;
import net.enilink.komma.edit.assist.ParboiledProposalProvider;
import net.enilink.komma.edit.assist.ReflectiveSemanticProposals;
import net.enilink.komma.edit.properties.IProposalSupport;
import net.enilink.komma.edit.properties.ResourceEditingSupport;
import net.enilink.komma.edit.properties.ResourceFinder;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.parser.manchester.IManchesterActions;
import net.enilink.komma.parser.manchester.ManchesterSyntaxParser;
import net.enilink.komma.parser.sparql.tree.BNode;
import net.enilink.komma.parser.sparql.tree.BooleanLiteral;
import net.enilink.komma.parser.sparql.tree.DoubleLiteral;
import net.enilink.komma.parser.sparql.tree.GenericLiteral;
import net.enilink.komma.parser.sparql.tree.IntegerLiteral;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.Literal;
import net.enilink.komma.parser.sparql.tree.QName;
import net.enilink.komma.parser.sparql.tree.visitor.TreeWalker;
import net.enilink.komma.parser.sparql.tree.visitor.Visitor;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class ManchesterEditingSupport
extends ResourceEditingSupport {
    public ManchesterEditingSupport(IAdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected CommandResult addStatements(IEntityManager em, Object subject, List<Object[]> stmts) {
        HashMap<BNode, IReference> bNodes = new HashMap<BNode, IReference>();
        ArrayList<Statement> realStmts = new ArrayList<Statement>();
        for (Object[] stmt : stmts) {
            Object s = stmt[0];
            Object p = stmt[1];
            Object o = stmt[2];
            realStmts.add(new Statement((IReference)this.toValue(em, s, bNodes), (IReference)this.toValue(em, p, bNodes), (Object)this.toValue(em, o, bNodes)));
        }
        em.add(realStmts);
        return CommandResult.newOKCommandResult((Object)this.toValue(em, subject, bNodes));
    }

    protected IValue toValue(final IEntityManager em, Object value, final Map<BNode, IReference> bNodes) {
        if (value instanceof BNode) {
            IReference reference = bNodes.get(value);
            if (reference == null) {
                reference = em.create(new IReference[0]);
                bNodes.put((BNode)value, reference);
            }
            return reference;
        }
        if (value instanceof IriRef || value instanceof QName) {
            return this.toURI(em, value);
        }
        if (value instanceof Literal) {
            final IValue[] result = new IValue[1];
            ((Literal)value).accept((Visitor)new TreeWalker<Void>(){

                public Boolean integerLiteral(IntegerLiteral numericLiteral, Void data) {
                    result[0] = em.toValue((Object)numericLiteral.getValue());
                    return false;
                }

                public Boolean booleanLiteral(BooleanLiteral booleanLiteral, Void data) {
                    result[0] = em.toValue((Object)booleanLiteral.getValue());
                    return false;
                }

                public Boolean doubleLiteral(DoubleLiteral doubleLiteral, Void data) {
                    result[0] = em.toValue((Object)doubleLiteral.getValue());
                    return false;
                }

                public Boolean genericLiteral(GenericLiteral genericLiteral, Void data) {
                    result[0] = em.createLiteral(genericLiteral.getLabel(), (URI)ManchesterEditingSupport.this.toValue(em, genericLiteral.getDatatype(), bNodes), genericLiteral.getLanguage());
                    return false;
                }
            }, null);
            return result[0];
        }
        return (IReference)value;
    }

    @Override
    public IProposalSupport getProposalSupport(Object element) {
        final IEntity subject = this.getSubject(element);
        if (subject == null) {
            return null;
        }
        final IItemLabelProvider resourceLabelProvider = super.getProposalSupport(element).getLabelProvider();
        final ManchesterSyntaxParser parser = (ManchesterSyntaxParser)Parboiled.createParser(ManchesterSyntaxParser.class, (Object[])new Object[]{new ManchesterActions()});
        return new IProposalSupport(){

            @Override
            public IContentProposalProvider getProposalProvider() {
                return new ParboiledProposalProvider(parser.Description(), new ManchesterProposals(subject.getEntityManager(), subject));
            }

            @Override
            public char[] getAutoActivationCharacters() {
                return null;
            }

            @Override
            public IItemLabelProvider getLabelProvider() {
                return new IItemLabelProvider(){

                    @Override
                    public String getText(Object object) {
                        if (object instanceof ResourceEditingSupport.ResourceProposal) {
                            return resourceLabelProvider.getText(object);
                        }
                        return ((IContentProposal)object).getLabel();
                    }

                    @Override
                    public Object getImage(Object object) {
                        if (object instanceof ResourceEditingSupport.ResourceProposal) {
                            return resourceLabelProvider.getImage(object);
                        }
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public ICommand convertEditorValue(final Object editorValue, final IEntityManager entityManager, Object element) {
        return new SimpleCommand(){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                final ArrayList<Object[]> newStmts = new ArrayList<Object[]>();
                ParsingResult result = new ReportingParseRunner(((ManchesterSyntaxParser)Parboiled.createParser(ManchesterSyntaxParser.class, (Object[])new Object[]{new ManchesterActions(){

                    @Override
                    public boolean createStmt(Object subject, Object predicate, Object object) {
                        newStmts.add(new Object[]{subject, predicate, object});
                        return true;
                    }
                }})).Description()).run((String)editorValue);
                if (result.matched && result.resultValue != null) {
                    return ManchesterEditingSupport.this.addStatements(entityManager, result.resultValue, newStmts);
                }
                return CommandResult.newErrorCommandResult((String)ErrorUtils.printParseErrors((List)result.parseErrors));
            }
        };
    }

    class ManchesterProposals
    extends ReflectiveSemanticProposals {
        IEntityManager em;
        IEntity subject;

        public ManchesterProposals(IEntityManager em, IEntity subject) {
            this.em = em;
            this.subject = subject;
        }

        public IContentProposal[] IriRef(ParsingResult<?> result, int index, String prefix) {
            StringBuilder text = new StringBuilder();
            for (int l = 1; l <= result.inputBuffer.getLineCount(); ++l) {
                text.append(result.inputBuffer.extractLine(l));
            }
            int insertPos = index - prefix.length();
            ArrayList<ResourceEditingSupport.ResourceProposal> proposals = new ArrayList<ResourceEditingSupport.ResourceProposal>();
            int limit = 20;
            ResourceFinder.Options options = this.subject == null ? ResourceFinder.Options.create(this.em, null, prefix, limit) : ResourceFinder.Options.create(this.subject, prefix, limit);
            for (ResourceFinder.Match match : new ResourceFinder().findAnyResources(options)) {
                String label = ManchesterEditingSupport.this.getLabel(match.resource);
                String origText = text.substring(insertPos, index);
                text.replace(insertPos, index, label);
                proposals.add(new ResourceEditingSupport.ResourceProposal(ManchesterEditingSupport.this, text.toString(), insertPos + label.length(), match.resource).setUseAsValue(text.length() == label.length()));
                text.replace(insertPos, insertPos + label.length(), origText);
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }

    class ManchesterActions
    implements IManchesterActions {
        ManchesterActions() {
        }

        public boolean createStmt(Object subject, Object predicate, Object object) {
            return true;
        }
    }
}

