/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.IdentityCommand;
import net.enilink.komma.common.command.SimpleCommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.edit.assist.ContentProposal;
import net.enilink.komma.edit.assist.IContentProposal;
import net.enilink.komma.edit.assist.IContentProposalProvider;
import net.enilink.komma.edit.properties.IEditingSupport;
import net.enilink.komma.edit.properties.IProposalSupport;
import net.enilink.komma.edit.properties.IResourceProposal;
import net.enilink.komma.edit.properties.ResourceFinder;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.parser.BaseRdfParser;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.QName;
import net.enilink.vocab.rdf.RDF;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.parserunners.BasicParseRunner;
import org.parboiled.support.IndexRange;
import org.parboiled.support.ParsingResult;

public class ResourceEditingSupport
implements IEditingSupport {
    protected IAdapterFactory adapterFactory;
    private boolean editPredicate;

    public ResourceEditingSupport(IAdapterFactory adapterFactory) {
        this(adapterFactory, false);
    }

    public ResourceEditingSupport(IAdapterFactory adapterFactory, boolean editPredicate) {
        this.adapterFactory = adapterFactory;
        this.editPredicate = editPredicate;
    }

    protected String getLabel(Object value) {
        if (value == null) {
            return "";
        }
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(value, IItemLabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText(value);
        }
        return value.toString();
    }

    protected ConstructorParser createConstructorParser() {
        return (ConstructorParser)Parboiled.createParser(ConstructorParser.class, (Object[])new Object[0]);
    }

    protected IStatement getStatement(Object element) {
        if (element instanceof IStatement) {
            return (IStatement)element;
        }
        return null;
    }

    @Override
    public IProposalSupport getProposalSupport(Object element) {
        final IStatement stmt = this.getStatement(element);
        if (stmt == null) {
            return null;
        }
        return new IProposalSupport(){

            @Override
            public IContentProposalProvider getProposalProvider() {
                return new ResourceProposalProvider((IEntity)stmt.getSubject(), stmt.getPredicate());
            }

            @Override
            public IItemLabelProvider getLabelProvider() {
                return new IItemLabelProvider(){

                    @Override
                    public String getText(Object object) {
                        if (object instanceof ResourceProposal) {
                            IEntity resource = ((ResourceProposal)object).resource;
                            IItemLabelProvider labelProvider = (IItemLabelProvider)ResourceEditingSupport.this.adapterFactory.adapt((Object)resource, IItemLabelProvider.class);
                            if (labelProvider != null) {
                                return labelProvider.getText(resource);
                            }
                            return ModelUtil.getLabel((Object)resource);
                        }
                        return ((ContentProposal)object).getLabel();
                    }

                    @Override
                    public Object getImage(Object object) {
                        IEntity resource;
                        IItemLabelProvider labelProvider;
                        if (object instanceof ResourceProposal && (labelProvider = (IItemLabelProvider)ResourceEditingSupport.this.adapterFactory.adapt((Object)(resource = ((ResourceProposal)object).resource), IItemLabelProvider.class)) != null) {
                            return labelProvider.getImage(resource);
                        }
                        return null;
                    }
                };
            }

            @Override
            public char[] getAutoActivationCharacters() {
                return null;
            }
        };
    }

    @Override
    public boolean canEdit(Object element) {
        return true;
    }

    @Override
    public Object getEditorValue(Object element) {
        Object value = null;
        IStatement stmt = this.getStatement(element);
        if (stmt != null) {
            value = this.editPredicate ? stmt.getPredicate() : stmt.getObject();
        }
        return value != null ? this.getLabel(value) : "";
    }

    protected URI toURI(IEntityManager manager, Object value) {
        if (value instanceof IriRef) {
            URI uri = URIs.createURI((String)((IriRef)value).getIri());
            if (uri.isRelative()) {
                URI ns = manager.getNamespace("");
                if (ns != null) {
                    uri = ns.fragment() != null ? ns.appendLocalPart(uri.toString()) : uri.resolve(ns);
                } else {
                    throw new IllegalArgumentException("Relative IRIs are not supported.");
                }
            }
            return uri;
        }
        if (value instanceof QName) {
            URI ns;
            String prefix = ((QName)value).getPrefix();
            String localPart = ((QName)value).getLocalPart();
            if (prefix == null || prefix.trim().length() == 0) {
                prefix = "";
            }
            if ((ns = manager.getNamespace(prefix)) != null) {
                return ns.appendLocalPart(localPart);
            }
            throw new IllegalArgumentException("Unknown prefix for QName " + value);
        }
        if (value != null) {
            ParsingResult iriRef = new BasicParseRunner(this.createConstructorParser().IriRef()).run(value.toString());
            if (iriRef.matched) {
                return this.toURI(manager, iriRef.resultValue);
            }
            URI ns = manager.getNamespace("");
            if (ns != null) {
                return ns.appendLocalPart(value.toString());
            }
            throw new IllegalArgumentException("Relative IRIs are not supported.");
        }
        return null;
    }

    protected IEntity getSubject(Object element) {
        if (element instanceof IEntity) {
            return (IEntity)element;
        }
        IStatement stmt = this.getStatement(element);
        return (IEntity)(stmt != null && stmt.getSubject() instanceof IEntity ? stmt.getSubject() : null);
    }

    @Override
    public ICommand convertEditorValue(Object editorValue, final IEntityManager entityManager, Object element) {
        ResourceFinder.Options options;
        URI uri;
        if (editorValue instanceof IValue) {
            return new IdentityCommand(editorValue);
        }
        String valueStr = editorValue.toString().trim();
        if (valueStr.isEmpty()) {
            return new IdentityCommand("Remove element.");
        }
        final URI[] name = new URI[]{null};
        final boolean[] createNew = new boolean[]{false};
        ParsingResult ctor = new BasicParseRunner(this.createConstructorParser().Constructor()).run(valueStr);
        if (ctor.matched) {
            createNew[0] = true;
            IndexRange range = (IndexRange)ctor.resultValue;
            valueStr = valueStr.substring(range.start, range.end);
            if (ctor.valueStack.size() > 1) {
                name[0] = this.toURI(entityManager, ctor.valueStack.peek(1));
            }
        }
        boolean forced = false;
        if (valueStr.endsWith("!") && valueStr.length() > 1) {
            forced = true;
            valueStr = valueStr.substring(0, valueStr.length() - 1);
        }
        if ((uri = this.toURI(entityManager, valueStr)) != null && (forced || entityManager.hasMatch((IReference)uri, null, null))) {
            return new SimpleCommand(){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    if (createNew[0] && name[0] != null) {
                        return CommandResult.newOKCommandResult((Object)entityManager.createNamed(name[0], new IReference[]{uri}));
                    }
                    if (createNew[0]) {
                        return CommandResult.newOKCommandResult((Object)entityManager.create(new IReference[]{uri}));
                    }
                    return CommandResult.newOKCommandResult((Object)entityManager.find((IReference)uri));
                }
            };
        }
        IStatement stmt = this.getStatement(element);
        Object oldValue = null;
        IReference property = null;
        if (stmt != null) {
            options = ResourceFinder.Options.create((IEntity)stmt.getSubject(), (String)editorValue, 1);
            property = stmt.getPredicate();
            oldValue = property == null ? null : stmt.getObject();
        } else {
            options = ResourceFinder.Options.create(entityManager, null, (String)editorValue, 1);
        }
        Iterator<ResourceFinder.Match> matches = new ResourceFinder().findAnyResources(options.forPredicate(createNew[0] ? null : property)).iterator();
        if (matches.hasNext()) {
            final IEntity resource = matches.next().resource;
            if (createNew[0] && this.getLabel(resource).equals(valueStr)) {
                return new SimpleCommand(){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        return CommandResult.newOKCommandResult((Object)entityManager.createNamed(name[0], new IReference[]{resource}));
                    }
                };
            }
            if (!resource.equals(oldValue) && this.getLabel(resource).equals(valueStr)) {
                return new IdentityCommand((Object)resource);
            }
        }
        return null;
    }

    class ResourceProposalProvider
    implements IContentProposalProvider {
        IEntity subject;
        IReference predicate;

        ResourceProposalProvider(IEntity subject, IReference predicate) {
            this.subject = subject;
            this.predicate = predicate;
        }

        @Override
        public IContentProposal[] getProposals(String contents, int position) {
            ParsingResult ctor = new BasicParseRunner(ResourceEditingSupport.this.createConstructorParser().Constructor()).run(contents);
            String prefix = "";
            if (ctor.matched) {
                IndexRange range = (IndexRange)ctor.resultValue;
                prefix = contents.substring(0, range.start);
                contents = contents.substring(range.start, range.end);
                position = contents.length();
            }
            int limit = 20;
            LinkedHashSet<IReference> predicates = new LinkedHashSet<IReference>();
            if (!ctor.matched) {
                predicates.add(this.predicate);
            }
            predicates.add(null);
            LinkedHashMap<IEntity, ResourceFinder.Match> allMatches = new LinkedHashMap<IEntity, ResourceFinder.Match>();
            ResourceFinder.Options options = ResourceFinder.Options.create(this.subject, contents.substring(0, position), limit);
            if (ResourceEditingSupport.this.editPredicate) {
                options = options.ofType((IReference)RDF.TYPE_PROPERTY);
            }
            ResourceFinder finder = new ResourceFinder();
            for (IReference p : predicates) {
                if (allMatches.size() >= limit) break;
                for (ResourceFinder.Match match : finder.findRestrictedResources(options.forPredicate(p))) {
                    ResourceFinder.Match existing = (ResourceFinder.Match)allMatches.get(match.resource);
                    if (existing != null && existing.score() >= match.score()) continue;
                    allMatches.put(match.resource, match);
                }
            }
            List<ResourceProposal> resourceProposals = this.toProposals(allMatches.values(), prefix, !ctor.matched);
            Comparator<ResourceProposal> comparator = new Comparator<ResourceProposal>(){

                @Override
                public int compare(ResourceProposal p1, ResourceProposal p2) {
                    int scoreDiff = p2.score - p1.score;
                    if (scoreDiff != 0) {
                        return scoreDiff;
                    }
                    return p1.getLabel().compareTo(p2.getLabel());
                }
            };
            Collections.sort(resourceProposals, comparator);
            List<ResourceProposal> results = resourceProposals;
            if (resourceProposals.size() < limit && !contents.contains(":")) {
                final String contentsFinal = contents;
                ArrayList<ResourceProposal> mixedProposals = new ArrayList<ResourceProposal>(resourceProposals);
                try (IExtendedIterator it = this.subject.getEntityManager().getNamespaces().filterKeep((Filter)new Filter<INamespace>(){

                    public boolean accept(INamespace ns) {
                        return ns.getPrefix().startsWith(contentsFinal);
                    }
                });){
                    while (it.hasNext() && mixedProposals.size() < limit) {
                        INamespace ns = (INamespace)it.next();
                        mixedProposals.add((ResourceProposal)new ContentProposal(ns.getPrefix() + ":", ns.getPrefix() + ":", ns.getURI().toString()));
                    }
                }
                results = mixedProposals;
            }
            return results.toArray(new IContentProposal[results.size()]);
        }

        protected List<ResourceProposal> toProposals(Iterable<ResourceFinder.Match> matches, String prefix, boolean useAsValue) {
            ArrayList<ResourceProposal> proposals = new ArrayList<ResourceProposal>();
            for (ResourceFinder.Match match : matches) {
                String content = ResourceEditingSupport.this.getLabel(match.resource);
                if (content.length() <= 0) continue;
                content = prefix + content;
                proposals.add(new ResourceProposal(content, content.length(), match.resource).setUseAsValue(useAsValue).setScore(match.score()));
            }
            return proposals;
        }
    }

    protected class ResourceProposal
    extends ContentProposal
    implements IResourceProposal {
        IEntity resource;
        boolean useAsValue;
        int score;

        public ResourceProposal(String content, int cursorPosition, IEntity resource) {
            super(content, ResourceEditingSupport.this.getLabel(resource), ResourceEditingSupport.this.getLabel(resource), cursorPosition, false);
            this.resource = resource;
        }

        @Override
        public IEntity getResource() {
            return this.resource;
        }

        public ResourceProposal setScore(int score) {
            this.score = score;
            return this;
        }

        @Override
        public int getScore() {
            return this.score;
        }

        public ResourceProposal setUseAsValue(boolean useAsValue) {
            this.useAsValue = useAsValue;
            return this;
        }

        @Override
        public boolean getUseAsValue() {
            return this.useAsValue;
        }
    }

    static class ConstructorParser
    extends BaseRdfParser {
        ConstructorParser() {
        }

        public Rule Constructor() {
            return this.Sequence(this.FirstOf(this.Sequence(this.FirstOf(this.IriRef(), this.PN_LOCAL(), new Object[0]), this.Ch('a'), new Object[0]), this.Ch('a'), new Object[0]), this.WS_NO_COMMENT(), new Object[]{this.FirstOf(this.IriRef(), this.PN_LOCAL(), new Object[]{this.Sequence(EMPTY, this.push(""), new Object[0])}), this.drop(), this.push(this.matchRange())});
        }
    }
}

