/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.enilink.komma.common.adapter.IAdapter;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.edit.provider.IDisposable;

public abstract class AdapterFactory
implements IAdapterFactory,
IDisposable {
    private Map<Object, List<Object>> object2adapters = Collections.synchronizedMap(new WeakHashMap());

    public Object adapt(Object object, Object type) {
        if (type instanceof Class && ((Class)type).isAssignableFrom(object.getClass())) {
            return object;
        }
        Object objectReference = object instanceof IReferenceable ? ((IReferenceable)object).getReference() : object;
        List<Object> adapters = this.object2adapters.get(objectReference);
        Object adapter = null;
        if (adapters != null) {
            for (Object a : adapters) {
                if (a instanceof IAdapter) {
                    if (!((IAdapter)a).isAdapterForType(type)) continue;
                    adapter = a;
                    break;
                }
                if (!(type instanceof Class) || !((Class)type).isAssignableFrom(a.getClass())) continue;
                adapter = a;
                break;
            }
        }
        if (adapter == null) {
            adapter = this.createAdapter(object, type);
            if (adapter == null || adapter instanceof IAdapter && !((IAdapter)adapter).isAdapterForType(type)) {
                return null;
            }
            if (adapters == null) {
                adapters = new CopyOnWriteArrayList<Object>();
                this.object2adapters.put(objectReference, adapters);
            }
            adapters.add(adapter);
            if (adapter instanceof IAdapter) {
                ((IAdapter)adapter).addTarget(object);
            }
        }
        return adapter;
    }

    protected abstract Object createAdapter(Object var1, Object var2);

    public void unlinkAdapter(Object object) {
        List<Object> adapter = this.object2adapters.remove(object);
        if (adapter instanceof IAdapter) {
            ((IAdapter)adapter).removeTarget(object);
        }
    }

    public boolean isFactoryForType(Object type) {
        return false;
    }

    @Override
    public void dispose() {
    }
}

