/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IDisposable;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IResource;

public class ComposedAdapterFactory
extends NotificationSupport<INotification>
implements IComposeableAdapterFactory,
IDisposable {
    protected List<IAdapterFactory> adapterFactories = new CopyOnWriteArrayList<IAdapterFactory>();
    protected IDescriptor.IRegistry adapterFactoryDescriptorRegistry;
    protected ComposedAdapterFactory parentAdapterFactory;
    @Inject
    protected Injector injector;

    public ComposedAdapterFactory() {
    }

    public ComposedAdapterFactory(Collection<? extends IAdapterFactory> adapterFactories) {
        for (IAdapterFactory iAdapterFactory : adapterFactories) {
            this.appendAdapterFactory(iAdapterFactory);
        }
    }

    public ComposedAdapterFactory(IAdapterFactory adapterFactory) {
        this.appendAdapterFactory(adapterFactory);
    }

    public ComposedAdapterFactory(IAdapterFactory[] adapterFactories) {
        for (int i = 0; i < adapterFactories.length; ++i) {
            this.appendAdapterFactory(adapterFactories[i]);
        }
    }

    public ComposedAdapterFactory(IDescriptor.IRegistry adapterFactoryDescriptorRegistry) {
        this.adapterFactoryDescriptorRegistry = adapterFactoryDescriptorRegistry;
    }

    public Object adapt(Object target, Object type) {
        Object adapter = this.internalAdapt(target, type);
        if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
            return adapter;
        }
        return null;
    }

    protected Object adaptEntity(IResource target, Object type, Set<URI> seenNamespaces, Collection<IClass> seenClasses, List<IClass> classes) {
        ArrayList<Object> typesCache = new ArrayList<Object>();
        if (seenClasses != null) {
            seenClasses.addAll(classes);
        }
        while (!classes.isEmpty()) {
            URI namespace;
            IClass resourceClass = classes.remove(0);
            URI name = resourceClass.getURI();
            if (name == null) continue;
            try {
                namespace = name.namespace();
            }
            catch (Exception e) {
                KommaEditPlugin.INSTANCE.log(e);
                continue;
            }
            if (seenNamespaces.add(namespace)) {
                Object result;
                IAdapterFactory delegateAdapterFactory;
                typesCache.add(namespace);
                if (type != null) {
                    typesCache.add(type);
                }
                if ((delegateAdapterFactory = this.getFactoryForTypes(typesCache)) != null && (result = delegateAdapterFactory.adapt((Object)target, type)) != null) {
                    return result;
                }
                typesCache.clear();
            }
            if (seenClasses == null) continue;
            for (IClass superClass : resourceClass.getDirectNamedSuperClasses()) {
                if (!seenClasses.add(superClass)) continue;
                int index = Collections.binarySearch(classes, superClass, IResource.RANK_COMPARATOR);
                if (index < 0) {
                    index = -(index + 1);
                }
                classes.add(index, superClass);
            }
        }
        IAdapterFactory defaultAdapterFactory = this.getDefaultAdapterFactory(type);
        return defaultAdapterFactory != null ? defaultAdapterFactory.adapt((Object)target, type) : null;
    }

    protected IAdapterFactory getDefaultAdapterFactory(Object type) {
        return null;
    }

    protected Object adaptJavaObject(Object target, Object type, Collection<Object> failedPackages, Class<?> javaClass) {
        IAdapterFactory defaultAdapterFactory;
        Object result = null;
        Package javaPackage = javaClass.getPackage();
        if (failedPackages.add(javaPackage)) {
            IAdapterFactory delegateAdapterFactory;
            ArrayList<Object> types = new ArrayList<Object>();
            types.add(javaPackage);
            if (type != null) {
                types.add(type);
            }
            if ((delegateAdapterFactory = this.getFactoryForTypes(types)) != null) {
                result = delegateAdapterFactory.adapt(target, type);
            }
        }
        if (result == null) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass != null) {
                result = this.adaptJavaObject(target, type, failedPackages, javaClass.getSuperclass());
            }
            if (result == null) {
                Class<?>[] interfaces = javaClass.getInterfaces();
                for (int i = 0; i < interfaces.length && (result = this.adaptJavaObject(target, type, failedPackages, interfaces[i])) == null; ++i) {
                }
            }
        }
        if (result == null && (defaultAdapterFactory = this.getDefaultAdapterFactory(type)) != null) {
            result = defaultAdapterFactory.adapt(target, type);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAdapterFactory(IAdapterFactory adapterFactory) {
        List<IAdapterFactory> list = this.adapterFactories;
        synchronized (list) {
            if (!this.adapterFactories.contains(adapterFactory)) {
                this.adapterFactories.add(adapterFactory);
                if (adapterFactory instanceof IComposeableAdapterFactory) {
                    ((IComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
                }
            }
        }
    }

    protected IAdapterFactory delegatedGetFactoryForTypes(Collection<?> types) {
        return null;
    }

    @Override
    public void dispose() {
        for (IAdapterFactory factory : this.adapterFactories) {
            if (!(factory instanceof IDisposable)) continue;
            ((IDisposable)factory).dispose();
        }
    }

    public void fireNotifications(Collection<? extends INotification> notifications) {
        super.fireNotifications(notifications);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifications(notifications);
        }
    }

    public IAdapterFactory getFactoryForTypes(Collection<?> types) {
        IDescriptor descriptor;
        IAdapterFactory result = null;
        block0: for (IAdapterFactory factory : this.adapterFactories) {
            if (factory instanceof ComposedAdapterFactory) {
                IAdapterFactory candidate = ((ComposedAdapterFactory)factory).getFactoryForTypes(types);
                if (candidate == null) continue;
                return candidate;
            }
            for (Object type : types) {
                if (factory.isFactoryForType(type)) continue;
                continue block0;
            }
            return factory;
        }
        if (this.adapterFactoryDescriptorRegistry != null && (descriptor = this.adapterFactoryDescriptorRegistry.getDescriptor(types)) != null) {
            result = descriptor.createAdapterFactory();
            if (null != this.injector) {
                this.injector.injectMembers((Object)result);
            }
            this.appendAdapterFactory(result);
        }
        return result == null ? this.delegatedGetFactoryForTypes(types) : result;
    }

    @Override
    public IComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependAdapterFactory(IAdapterFactory adapterFactory) {
        List<IAdapterFactory> list = this.adapterFactories;
        synchronized (list) {
            if (!this.adapterFactories.contains(adapterFactory)) {
                this.adapterFactories.add(0, adapterFactory);
                if (adapterFactory instanceof IComposeableAdapterFactory) {
                    ((IComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
                }
            }
        }
    }

    protected Object internalAdapt(Object target, Object type) {
        IAdapterFactory factory;
        URI uri;
        Object result = null;
        if (target instanceof IReference && (uri = ((IReference)target).getURI()) != null && (factory = this.getFactoryForTypes(Arrays.asList(uri.namespace(), type))) != null) {
            result = factory.adapt(target, type);
        }
        if (result != null) {
            return result;
        }
        if (target instanceof IResource) {
            IResource resource = (IResource)target;
            result = this.adaptEntity(resource, type, new HashSet<URI>(), new HashSet<IClass>(), this.sort(resource.getDirectNamedClasses().toList()));
        }
        if (result != null) {
            return result;
        }
        if (target != null) {
            result = this.adaptJavaObject(target, type, new HashSet<Object>(), target.getClass());
        }
        return result == null ? target : result;
    }

    private List<IClass> sort(List<IClass> classes) {
        Collections.sort(classes, IResource.RANK_COMPARATOR);
        return classes;
    }

    public boolean isFactoryForType(Object type) {
        for (IAdapterFactory adapterFactory : this.adapterFactories) {
            if (!adapterFactory.isFactoryForType(type)) continue;
            return true;
        }
        return false;
    }

    public void removeAdapterFactory(IAdapterFactory adapterFactory) {
        if (this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.remove(adapterFactory);
            if (adapterFactory instanceof IComposeableAdapterFactory) {
                ((IComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(null);
            }
        }
    }

    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public static interface IDescriptor {
        public IAdapterFactory createAdapterFactory();

        public static interface IRegistry {
            public static final IRegistry INSTANCE = KommaEditPlugin.getComposedAdapterFactoryDescriptorRegistry();

            public IDescriptor getDescriptor(Collection<?> var1);

            public static class Impl
            extends ConcurrentHashMap<Collection<?>, Object>
            implements IRegistry {
                private static final long serialVersionUID = 1L;
                protected IRegistry delegateRegistry;

                public Impl(IRegistry delegateRegistry) {
                    this.delegateRegistry = delegateRegistry;
                }

                protected IDescriptor delegatedGetDescriptor(Collection<?> types) {
                    if (this.delegateRegistry != null) {
                        return this.delegateRegistry.getDescriptor(types);
                    }
                    return null;
                }

                @Override
                public IDescriptor getDescriptor(Collection<?> types) {
                    IDescriptor descriptor = (IDescriptor)this.get(types);
                    return descriptor == null ? this.delegatedGetDescriptor(types) : descriptor;
                }
            }
        }
    }
}

