/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.Collection;
import java.util.HashMap;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotifier;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.edit.provider.ComposedAdapterFactory;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IDisposable;
import net.enilink.komma.edit.provider.IItemProviderDecorator;

public abstract class DecoratorAdapterFactory
extends NotificationSupport<INotification>
implements IAdapterFactory,
IComposeableAdapterFactory,
IDisposable {
    protected HashMap<Object, IItemProviderDecorator> itemProviderDecorators = new HashMap();
    protected IAdapterFactory decoratedAdapterFactory;
    protected ComposedAdapterFactory parentAdapterFactory;

    public DecoratorAdapterFactory(IAdapterFactory decoratedAdapterFactory) {
        this.decoratedAdapterFactory = decoratedAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.decoratedAdapterFactory.isFactoryForType(type);
    }

    public IAdapterFactory getDecoratedAdapterFactory() {
        return this.decoratedAdapterFactory;
    }

    public void setDecoratedAdapterFactory(IAdapterFactory decoratedAdapterFactory) {
        this.decoratedAdapterFactory = decoratedAdapterFactory;
    }

    protected abstract IItemProviderDecorator createItemProviderDecorator(Object var1, Object var2);

    public Object adapt(Object target, Object type) {
        Object adapter = this.decoratedAdapterFactory.adapt(target, type);
        if (adapter instanceof INotifier) {
            IItemProviderDecorator itemProviderDecorator = this.itemProviderDecorators.get(adapter);
            if (itemProviderDecorator == null) {
                itemProviderDecorator = this.createItemProviderDecorator(target, type);
                this.itemProviderDecorators.put(adapter, itemProviderDecorator);
                itemProviderDecorator.setDecoratedItemProvider((INotifier<INotification>)((INotifier)adapter));
            }
            return itemProviderDecorator;
        }
        return adapter;
    }

    @Override
    public IComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public void fireNotifications(Collection<? extends INotification> notifications) {
        super.fireNotifications(notifications);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifications(notifications);
        }
    }

    @Override
    public void dispose() {
        for (IItemProviderDecorator object : this.itemProviderDecorators.values()) {
            if (!(object instanceof IDisposable)) continue;
            ((IDisposable)((Object)object)).dispose();
        }
    }
}

