/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationBroadcaster;
import net.enilink.komma.common.notify.INotificationListener;
import net.enilink.komma.common.notify.INotifier;
import net.enilink.komma.common.notify.IPropertyNotification;
import net.enilink.komma.common.notify.NotificationFilter;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.DragAndDropCommand;
import net.enilink.komma.edit.command.ICommandActionDelegate;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.IDisposable;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemColorProvider;
import net.enilink.komma.edit.provider.IItemFontProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.IStructuredItemContentProvider;
import net.enilink.komma.edit.provider.ITableItemColorProvider;
import net.enilink.komma.edit.provider.ITableItemFontProvider;
import net.enilink.komma.edit.provider.ITableItemLabelProvider;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.IViewerNotification;
import net.enilink.komma.edit.provider.IWrapperItemProvider;
import net.enilink.komma.edit.provider.ItemPropertyDescriptorDecorator;
import net.enilink.komma.edit.provider.ViewerNotification;
import net.enilink.komma.edit.provider.WrapperItemProvider;
import net.enilink.komma.model.event.IStatementNotification;

public class DelegatingWrapperItemProvider
extends WrapperItemProvider
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemFontProvider,
IItemColorProvider,
ITableItemLabelProvider,
ITableItemFontProvider,
ITableItemColorProvider,
IItemPropertySource,
IEditingDomainItemProvider,
INotifier<INotification>,
INotificationBroadcaster<INotification>,
INotificationListener<INotification> {
    protected Object delegateItemProvider;
    protected Map<Object, IWrapperItemProvider> childrenMap;
    protected Collection<?> delegateChildren;
    protected List<IItemPropertyDescriptor> propertyDescriptors;
    protected NotificationSupport<INotification> changeNotifier;

    public DelegatingWrapperItemProvider(Object value, Object owner, IReference property, int index, IAdapterFactory adapterFactory) {
        super(value, owner, property, index, adapterFactory);
        if (value == null) {
            throw new IllegalArgumentException("value=null");
        }
        Object delegateValue = this.getDelegateValue();
        if (delegateValue != null) {
            this.delegateItemProvider = this.getRootAdapterFactory().adapt(delegateValue, IStructuredItemContentProvider.class);
            if (this.delegateItemProvider instanceof INotifier) {
                ((INotifier)this.delegateItemProvider).addListener((INotificationListener)this);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.delegateItemProvider instanceof INotifier) {
            ((INotifier)this.delegateItemProvider).removeListener((INotificationListener)this);
        }
        if (this.childrenMap != null) {
            for (IDisposable iDisposable : this.childrenMap.values()) {
                iDisposable.dispose();
            }
        }
    }

    protected Object getDelegateValue() {
        return this.value;
    }

    @Override
    public Collection<?> getElements(Object object) {
        return this.delegateItemProvider instanceof IStructuredItemContentProvider ? ((IStructuredItemContentProvider)this.delegateItemProvider).getElements(this.getDelegateValue()) : Collections.emptyList();
    }

    @Override
    public Collection<?> getChildren(Object object) {
        this.updateChildren();
        ArrayList<IWrapperItemProvider> result = new ArrayList<IWrapperItemProvider>(this.delegateChildren.size());
        for (Object delegateChild : this.delegateChildren) {
            result.add(this.childrenMap.get(delegateChild));
        }
        return result;
    }

    protected void updateChildren() {
        if (this.delegateItemProvider instanceof ITreeItemContentProvider) {
            IWrapperItemProvider wrapper;
            boolean changed = false;
            HashSet oldDelegateChildren = this.delegateChildren != null ? new HashSet(this.delegateChildren) : Collections.emptySet();
            this.delegateChildren = ((ITreeItemContentProvider)this.delegateItemProvider).getChildren(this.getDelegateValue());
            if (this.childrenMap == null && !this.delegateChildren.isEmpty()) {
                this.childrenMap = new HashMap<Object, IWrapperItemProvider>();
            }
            for (Object child : this.delegateChildren) {
                if (!this.childrenMap.containsKey(child)) {
                    wrapper = this.createWrapper(child, this, this.adapterFactory);
                    this.childrenMap.put(child, wrapper);
                    changed = true;
                }
                oldDelegateChildren.remove(child);
            }
            if (!oldDelegateChildren.isEmpty()) {
                changed = true;
                for (Object child : oldDelegateChildren) {
                    wrapper = this.childrenMap.remove(child);
                    if (wrapper == null) continue;
                    wrapper.dispose();
                }
            }
            if (changed) {
                int index = 0;
                for (Object delegateChild : this.delegateChildren) {
                    this.childrenMap.get(delegateChild).setIndex(index);
                }
            }
        } else {
            this.delegateChildren = Collections.emptyList();
        }
    }

    protected IWrapperItemProvider createWrapper(Object value, Object owner, IAdapterFactory adapterFactory) {
        return new DelegatingWrapperItemProvider(value, owner, this.getProperty(), -1, adapterFactory);
    }

    @Override
    public boolean hasChildren(Object object) {
        return this.delegateItemProvider instanceof ITreeItemContentProvider ? ((ITreeItemContentProvider)this.delegateItemProvider).hasChildren(this.getDelegateValue()) : false;
    }

    @Override
    public String getText(Object object) {
        return this.delegateItemProvider instanceof IItemLabelProvider ? ((IItemLabelProvider)this.delegateItemProvider).getText(this.getDelegateValue()) : null;
    }

    @Override
    public Object getImage(Object object) {
        return this.delegateItemProvider instanceof IItemLabelProvider ? ((IItemLabelProvider)this.delegateItemProvider).getImage(this.getDelegateValue()) : null;
    }

    @Override
    public Object getFont(Object object) {
        return this.delegateItemProvider instanceof IItemFontProvider ? ((IItemFontProvider)this.delegateItemProvider).getFont(this.getDelegateValue()) : null;
    }

    @Override
    public Object getForeground(Object object) {
        return this.delegateItemProvider instanceof IItemColorProvider ? ((IItemColorProvider)this.delegateItemProvider).getForeground(this.getDelegateValue()) : null;
    }

    @Override
    public Object getBackground(Object object) {
        return this.delegateItemProvider instanceof IItemColorProvider ? ((IItemColorProvider)this.delegateItemProvider).getBackground(this.getDelegateValue()) : null;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        return this.delegateItemProvider instanceof ITableItemLabelProvider ? ((ITableItemLabelProvider)this.delegateItemProvider).getColumnText(this.getDelegateValue(), columnIndex) : this.getText(object);
    }

    @Override
    public Object getColumnImage(Object object, int columnIndex) {
        return this.delegateItemProvider instanceof ITableItemLabelProvider ? ((ITableItemLabelProvider)this.delegateItemProvider).getColumnImage(this.getDelegateValue(), columnIndex) : this.getImage(object);
    }

    @Override
    public Object getFont(Object object, int columnIndex) {
        return this.delegateItemProvider instanceof ITableItemFontProvider ? ((ITableItemFontProvider)this.delegateItemProvider).getFont(this.getDelegateValue(), columnIndex) : this.getFont(object);
    }

    @Override
    public Object getForeground(Object object, int columnIndex) {
        return this.delegateItemProvider instanceof ITableItemColorProvider ? ((ITableItemColorProvider)this.delegateItemProvider).getForeground(this.getDelegateValue(), columnIndex) : this.getFont(object);
    }

    @Override
    public Object getBackground(Object object, int columnIndex) {
        return this.delegateItemProvider instanceof ITableItemColorProvider ? ((ITableItemColorProvider)this.delegateItemProvider).getBackground(this.getDelegateValue(), columnIndex) : this.getFont(object);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.propertyDescriptors == null) {
            if (this.delegateItemProvider instanceof IItemPropertySource) {
                List<IItemPropertyDescriptor> l = ((IItemPropertySource)this.delegateItemProvider).getPropertyDescriptors(this.getDelegateValue());
                this.propertyDescriptors = new ArrayList<IItemPropertyDescriptor>(l.size());
                for (IItemPropertyDescriptor desc : l) {
                    this.propertyDescriptors.add(new DelegatingWrapperItemPropertyDescriptor(this.getDelegateValue(), desc));
                }
            } else {
                this.propertyDescriptors = Collections.emptyList();
            }
        }
        return this.propertyDescriptors;
    }

    @Override
    public Object getEditableValue(Object object) {
        return this.delegateItemProvider instanceof IItemPropertySource ? ((IItemPropertySource)this.delegateItemProvider).getEditableValue(this.getDelegateValue()) : null;
    }

    @Override
    public void getNewChildDescriptors(Object object, IEditingDomain editingDomain, Object sibling, ICollector<Object> descriptors) {
        if (this.delegateItemProvider instanceof IEditingDomainItemProvider) {
            ((IEditingDomainItemProvider)this.delegateItemProvider).getNewChildDescriptors(this.getDelegateValue(), editingDomain, sibling, descriptors);
        }
    }

    @Override
    public ICommand createCommand(Object object, IEditingDomain domain, Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
        if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getProperty();
            return this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        if (this.delegateItemProvider instanceof IEditingDomainItemProvider) {
            Object commandOwner = this.getDelegateValue();
            ICommand result = null;
            if (commandClass == SetCommand.class) {
                Object feature = commandParameter.getProperty();
                result = SetCommand.create(domain, commandOwner, feature, commandParameter.getValue(), commandParameter.getIndex());
                if (feature == null) {
                    return new WrapperItemProvider.ReplacementAffectedObjectCommand(this, result);
                }
            } else {
                commandParameter.setOwner(commandOwner);
                result = ((IEditingDomainItemProvider)this.delegateItemProvider).createCommand(commandOwner, domain, commandClass, commandParameter);
            }
            return this.wrapCommand(result, commandClass);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand wrapCommand(ICommand command, Class<? extends ICommand> commandClass) {
        return command instanceof ICommandActionDelegate ? new AffectedObjectsWrappingCommandActionDelegate((ICommandActionDelegate)command) : new AffectedObjectsWrappingCommand(command);
    }

    public void fireNotifications(Collection<? extends INotification> notifications) {
        if (this.adapterFactory instanceof INotificationBroadcaster) {
            INotificationBroadcaster adapterFactoryChangeNotifier = (INotificationBroadcaster)this.adapterFactory;
            adapterFactoryChangeNotifier.fireNotifications(notifications);
        }
        if (this.changeNotifier != null) {
            this.changeNotifier.fireNotifications(notifications);
        }
    }

    public void addListener(INotificationListener<INotification> listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new NotificationSupport();
        }
        this.changeNotifier.addListener(listener);
    }

    public void removeListener(INotificationListener<INotification> listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener(listener);
        }
    }

    public void notifyChanged(Collection<? extends INotification> notifications) {
        for (INotification iNotification : notifications) {
            if (!this.getRefreshElement(iNotification).equals(this.getDelegateValue())) continue;
            this.fireNotifications(Arrays.asList(this.wrapNotification(iNotification)));
        }
    }

    protected Object getRefreshElement(INotification notification) {
        if (notification instanceof IViewerNotification) {
            return ((IViewerNotification)notification).getElement();
        }
        if (notification instanceof IPropertyNotification) {
            return ((IPropertyNotification)notification).getSubject();
        }
        if (notification instanceof IStatementNotification) {
            return ((IStatementNotification)notification).getSubject();
        }
        return null;
    }

    protected INotification wrapNotification(INotification notification) {
        return ViewerNotification.wrapNotification(notification, this);
    }

    public NotificationFilter<INotification> getFilter() {
        return null;
    }

    protected class DelegatingWrapperItemPropertyDescriptor
    extends ItemPropertyDescriptorDecorator
    implements IItemPropertyDescriptor.OverrideableCommandOwner {
        protected Object commandOwner;

        public DelegatingWrapperItemPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        @Override
        public void setCommandOwner(Object commandOwner) {
            this.commandOwner = commandOwner;
            if (this.itemPropertyDescriptor instanceof IItemPropertyDescriptor.OverrideableCommandOwner) {
                ((IItemPropertyDescriptor.OverrideableCommandOwner)((Object)this.itemPropertyDescriptor)).setCommandOwner(commandOwner);
            }
        }

        @Override
        public Object getCommandOwner() {
            return this.commandOwner;
        }

        @Override
        public void resetPropertyValue(Object thisObject) {
            boolean hasCommandOwner;
            boolean bl = hasCommandOwner = this.commandOwner != null;
            if (!hasCommandOwner) {
                this.setCommandOwner(DelegatingWrapperItemProvider.this);
            }
            this.itemPropertyDescriptor.resetPropertyValue(this.object);
            if (!hasCommandOwner) {
                this.setCommandOwner(null);
            }
        }

        @Override
        public void setPropertyValue(Object thisObject, Object value) {
            boolean hasCommandOwner;
            boolean bl = hasCommandOwner = this.commandOwner != null;
            if (!hasCommandOwner) {
                this.setCommandOwner(DelegatingWrapperItemProvider.this);
            }
            this.itemPropertyDescriptor.setPropertyValue(this.object, value);
            if (!hasCommandOwner) {
                this.setCommandOwner(null);
            }
        }
    }

    protected class AffectedObjectsWrappingCommandActionDelegate
    extends AffectedObjectsWrappingCommand
    implements ICommandActionDelegate {
        ICommandActionDelegate commandActionDelegate;

        public AffectedObjectsWrappingCommandActionDelegate(ICommandActionDelegate command) {
            super((ICommand)command);
            this.commandActionDelegate = command;
        }

        @Override
        public boolean canExecute() {
            return this.commandActionDelegate.canExecute();
        }

        @Override
        public Object getImage() {
            return this.commandActionDelegate.getImage();
        }

        @Override
        public String getText() {
            return this.commandActionDelegate.getText();
        }

        @Override
        public String getDescription() {
            return this.commandActionDelegate.getDescription();
        }

        @Override
        public String getToolTipText() {
            return this.commandActionDelegate.getToolTipText();
        }
    }

    protected class AffectedObjectsWrappingCommand
    extends CommandWrapper {
        public AffectedObjectsWrappingCommand(ICommand command) {
            super(command);
        }

        public Collection<?> getAffectedObjects() {
            ArrayList result = new ArrayList(super.getAffectedObjects());
            DelegatingWrapperItemProvider.this.updateChildren();
            ListIterator<IWrapperItemProvider> i = result.listIterator();
            while (i.hasNext()) {
                IWrapperItemProvider wrapper;
                Object object = i.next();
                if (object == DelegatingWrapperItemProvider.this.getDelegateValue()) {
                    i.set(DelegatingWrapperItemProvider.this);
                    continue;
                }
                if (DelegatingWrapperItemProvider.this.childrenMap == null || (wrapper = DelegatingWrapperItemProvider.this.childrenMap.get(object)) == null) continue;
                i.set(wrapper);
            }
            return result;
        }
    }
}

