/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.provider.AdapterFactory;
import net.enilink.komma.edit.provider.ComposedImage;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemColorProvider;
import net.enilink.komma.edit.provider.IItemFontProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.ISearchableItemProvider;
import net.enilink.komma.edit.provider.IStructuredItemContentProvider;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.IViewerNotification;
import net.enilink.komma.edit.provider.ItemProviderAdapter;
import net.enilink.komma.edit.provider.SparqlSearchableItemProvider;
import net.enilink.komma.edit.provider.ViewerNotification;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.event.IStatementNotification;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.Class;
import net.enilink.vocab.rdfs.RDFS;

public class ReflectiveItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemColorProvider,
IItemFontProvider,
IItemLabelProvider,
IItemPropertySource,
ISearchableItemProvider {
    protected IResourceLocator resourceLocator;
    protected Collection<? extends IReference> targetTypes;

    public ReflectiveItemProvider(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, Collection<? extends IReference> targetTypes) {
        super(adapterFactory);
        this.resourceLocator = resourceLocator;
        this.targetTypes = targetTypes;
    }

    @Override
    public IResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Override
    public void notifyChanged(Collection<? extends INotification> notifications) {
        super.notifyChanged(notifications);
        ArrayList<IViewerNotification> viewerNotifications = new ArrayList<IViewerNotification>(0);
        for (INotification iNotification : notifications) {
            if (!(iNotification instanceof IStatementNotification)) continue;
            IStatementNotification stmtNotification = (IStatementNotification)iNotification;
            if (RDF.PROPERTY_TYPE.equals((Object)stmtNotification.getPredicate()) && this.adapterFactory instanceof AdapterFactory) {
                IEntity object = this.resolveReference(iNotification.getSubject());
                if (object != null) {
                    viewerNotifications.add(new ViewerNotification(object, true, true));
                }
                ((AdapterFactory)this.adapterFactory).unlinkAdapter(stmtNotification.getSubject());
            }
            this.addViewerNotifications(viewerNotifications, stmtNotification);
        }
        if (!viewerNotifications.isEmpty()) {
            this.fireNotifications(viewerNotifications);
            return;
        }
    }

    protected boolean updateLabel(IStatementNotification notification) {
        return RDFS.PROPERTY_LABEL.equals((Object)notification.getPredicate());
    }

    protected void addViewerNotifications(Collection<IViewerNotification> viewerNotifications, IStatementNotification notification) {
        IEntity object = this.resolveReference(notification.getSubject());
        if (object instanceof IResource) {
            ((IResource)object).refresh(notification.getPredicate());
            boolean labelUpdate = this.updateLabel(notification);
            viewerNotifications.add(new ViewerNotification(object, !labelUpdate, labelUpdate));
        }
    }

    @Override
    public Object getCreateChildImage(Object owner, Object property, Object childDescription, Collection<?> selection) {
        Object childType;
        if (childDescription instanceof ItemProviderAdapter.ChildDescriptor) {
            childDescription = ((ItemProviderAdapter.ChildDescriptor)childDescription).getValue();
        }
        String name = "full/ctool16/Create" + this.getTypes(owner).iterator().next().getURI().localPart() + "_" + ((IReference)property).getURI().localPart();
        Object object = childType = childDescription instanceof Collection ? ((Collection)childDescription).iterator().next() : childDescription;
        if (childType instanceof Class && ((IReference)childType).getURI() != null) {
            name = name + "_" + ((IReference)childType).getURI().localPart();
        }
        try {
            return this.getImage(name);
        }
        catch (Exception e) {
            Object itemImage;
            ArrayList<Object> images = new ArrayList<Object>();
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)((IComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory().adapt(childType, IItemLabelProvider.class);
            Object object2 = itemImage = itemLabelProvider != null ? itemLabelProvider.getImage(childType) : null;
            if (itemImage != null) {
                images.add(itemLabelProvider.getImage(childType));
                images.add(KommaEditPlugin.INSTANCE.getImage("full/ovr16/CreateChild"));
                return new ComposedCreateChildImage(images);
            }
            return super.getCreateChildImage(owner, property, childType, selection);
        }
    }

    @Override
    public Object getForeground(Object object) {
        if (object instanceof IEntity) {
            URI uri = ((IObject)object).getReference().getURI();
            if (uri != null && uri.namespace().equals((Object)((IEntity)object).getEntityManager().getNamespace(""))) {
                return super.getForeground(object);
            }
            return IItemColorProvider.GRAYED_OUT_COLOR;
        }
        return super.getForeground(object);
    }

    @Override
    public Object getFont(Object object) {
        URI uri;
        if (object instanceof IEntity && (uri = ((IObject)object).getReference().getURI()) != null && uri.namespace().equals((Object)((IEntity)object).getEntityManager().getNamespace(""))) {
            return IItemFontProvider.BOLD_FONT;
        }
        return super.getFont(object);
    }

    @Override
    public Object getImage(Object object) {
        for (IReference iReference : this.getTypes(object)) {
            try {
                return this.overlayImage(object, this.getImage("full/obj16/" + iReference.getURI().localPart()));
            }
            catch (Exception exception) {
            }
        }
        try {
            return this.overlayImage(object, this.getImage("full/obj16/Item"));
        }
        catch (Exception missing2) {
            return KommaEditPlugin.INSTANCE.getImage("full/obj16/Item");
        }
    }

    protected Collection<? extends IReference> getTypes(Object object) {
        return this.targetTypes;
    }

    @Override
    public String getText(Object object) {
        return ModelUtil.getLabel((Object)object);
    }

    protected ISearchableItemProvider getSearchableItemProvider() {
        return new SparqlSearchableItemProvider();
    }

    @Override
    public IExtendedIterator<?> find(Object expression, Object parent, int limit) {
        return this.getSearchableItemProvider().find(expression, parent, limit);
    }

    static class ComposedCreateChildImage
    extends ComposedImage {
        public ComposedCreateChildImage(Collection<?> images) {
            super(images);
        }

        @Override
        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List<ComposedImage.Point> result = super.getDrawPoints(size);
            result.get((int)1).x = size.width - 7;
            return result;
        }
    }
}

