/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.Arrays;
import java.util.regex.Pattern;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.komma.core.IDialect;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.QueryFragment;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.provider.ISearchableItemProvider;

public class SparqlSearchableItemProvider
implements ISearchableItemProvider {
    private static Pattern ESCAPE_CHARS = Pattern.compile("[\\[.{(*+?^$|]");

    protected IEntityManager getEntityManager(Object parent) {
        if (parent instanceof IEntity) {
            return ((IEntity)parent).getEntityManager();
        }
        return null;
    }

    protected String getQueryFindPatterns(Object parent) {
        return "?parent komma:child* ?s . ";
    }

    protected void setQueryParameters(IQuery<?> query, Object parent) {
        if (parent != null) {
            query.setParameter("parent", parent);
        }
    }

    protected String patternToRegex(String pattern) {
        pattern = ESCAPE_CHARS.matcher(pattern).replaceAll("\\\\$0");
        return pattern.replace("\\*", ".*").replace("\\?", ".");
    }

    @Override
    public IExtendedIterator<?> find(Object expression, Object parent, int limit) {
        IEntityManager em = this.getEntityManager(parent);
        if (expression instanceof String && em != null) {
            String pattern;
            String findPatterns = this.getQueryFindPatterns(parent);
            String uriPattern = pattern = (String)expression;
            if (!pattern.matches(".*[#/].*")) {
                int colonIndex = pattern.lastIndexOf(58);
                if (colonIndex == 0) {
                    pattern = pattern.substring(1);
                }
                uriPattern = "[#/:]" + this.patternToRegex(pattern) + "[^#/]*$";
                if (colonIndex > 0) {
                    String prefix = pattern.substring(0, colonIndex);
                    pattern = pattern.substring(colonIndex + 1);
                    URI namespaceUri = em.getNamespace(prefix);
                    if (namespaceUri != null) {
                        uriPattern = this.patternToRegex(namespaceUri.appendFragment("") + pattern);
                    }
                }
            }
            IDialect dialect = em.getFactory().getDialect();
            QueryFragment searchS = dialect.fullTextSearch(Arrays.asList("s"), 1, new String[]{pattern});
            QueryFragment searchL = dialect.fullTextSearch(Arrays.asList("l"), 0, new String[]{pattern});
            boolean isFilter = Pattern.compile("^\\s*filter", 2).matcher(searchS.toString()).find();
            String queryStr = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?s WHERE {" + (isFilter ? findPatterns : "") + "{ ?s rdfs:label ?l . " + searchL + " FILTER regex(str(?l), ?labelPattern, \"i\")} UNION {" + (isFilter ? " ?s ?p ?o . " : "") + searchS + " FILTER regex(str(?s), ?uriPattern, \"i\")} " + (isFilter ? "" : findPatterns) + "}";
            if (limit > 0) {
                queryStr = queryStr + " LIMIT " + limit;
            }
            IQuery query = em.createQuery(queryStr);
            searchS.addParameters(query);
            searchL.addParameters(query);
            query.setParameter("uriPattern", (Object)uriPattern);
            query.setParameter("labelPattern", (Object)this.patternToRegex(pattern));
            this.setQueryParameters(query, parent);
            return query.evaluate();
        }
        return WrappedIterator.emptyIterator();
    }
}

