/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.command.DragAndDropCommand;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.IWrapperItemProvider;
import net.enilink.komma.edit.provider.ItemPropertyDescriptor;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.vocab.rdfs.Class;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

public class WrapperItemProvider
implements IWrapperItemProvider {
    protected Object value;
    protected Object owner;
    protected IReference property;
    protected int index;
    protected IAdapterFactory adapterFactory;
    protected static final String COPY_COMMAND_LABEL = KommaEditPlugin.INSTANCE.getString("_UI_CopyCommand_label");
    protected static final String COPY_COMMAND_DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_CopyCommand_description");

    public WrapperItemProvider(Object value, Object owner, IReference property, int index, IAdapterFactory adapterFactory) {
        this.value = value;
        this.owner = owner;
        this.property = property;
        this.index = index;
        this.adapterFactory = adapterFactory;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public IReference getProperty() {
        return this.property;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public Collection<?> getElements(Object object) {
        return this.getChildren(object);
    }

    public Collection<?> getChildren(Object object) {
        return Collections.emptyList();
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    public Object getParent(Object object) {
        return this.owner;
    }

    public String getText(Object object) {
        return this.value != null ? this.value.toString() : "null";
    }

    public Object getImage(Object object) {
        return KommaEditPlugin.INSTANCE.getImage("full/obj16/Item");
    }

    public Object getFont(Object object) {
        return null;
    }

    public Object getForeground(Object object) {
        return null;
    }

    public Object getBackground(Object object) {
        return null;
    }

    public String getUpdateableText(Object object) {
        return this.getText(object);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        return Collections.emptyList();
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
        for (IItemPropertyDescriptor descriptor : this.getPropertyDescriptors(object)) {
            if (!propertyId.equals(descriptor.getId(object)) && !propertyId.equals(descriptor.getProperty(object))) continue;
            return descriptor;
        }
        return null;
    }

    public Object getEditableValue(Object object) {
        return this.value;
    }

    protected String getPropertyName() {
        return KommaEditPlugin.INSTANCE.getString("_UI_ValueProperty_name");
    }

    protected String getPropertyDescription() {
        return KommaEditPlugin.INSTANCE.getString("_UI_ValueProperty_description");
    }

    protected boolean isPropertySettable() {
        return true;
    }

    protected boolean isPropertyMultiLine() {
        return false;
    }

    protected boolean isPropertySortChoices() {
        return false;
    }

    protected Object getPropertyImage() {
        IProperty property = (IProperty)((IResource)this.getOwner()).getEntityManager().find(this.property);
        HashSet<String> ranges = new HashSet<String>();
        for (Class rangeClass : property.getRdfsRanges()) {
            ranges.add(rangeClass.getURI().toString());
        }
        return this.getPropertyImage(ranges);
    }

    protected Object getPropertyImage(Collection<String> ranges) {
        if (ranges.contains(XMLSCHEMA.TYPE_BOOLEAN.toString())) {
            return ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE;
        }
        if (ranges.contains(XMLSCHEMA.TYPE_BYTE.toString()) || ranges.contains(XMLSCHEMA.TYPE_INTEGER.toString()) || ranges.contains(XMLSCHEMA.TYPE_LONG.toString()) || ranges.contains(XMLSCHEMA.TYPE_SHORT.toString())) {
            return ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE;
        }
        if (ranges.contains(XMLSCHEMA.TYPE_STRING.toString())) {
            return ItemPropertyDescriptor.TEXT_VALUE_IMAGE;
        }
        if (ranges.contains(XMLSCHEMA.TYPE_DOUBLE.toString()) || ranges.contains(XMLSCHEMA.TYPE_FLOAT.toString())) {
            return ItemPropertyDescriptor.REAL_VALUE_IMAGE;
        }
        return ItemPropertyDescriptor.GENERIC_VALUE_IMAGE;
    }

    protected String getPropertyCategory() {
        return null;
    }

    protected String[] getPropertyFilterFlags() {
        return null;
    }

    public void getNewChildDescriptors(Object object, IEditingDomain editingDomain, Object sibling, ICollector<Object> descriptors) {
    }

    public ICommand createCommand(Object object, IEditingDomain domain, java.lang.Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
        return this.baseCreateCommand(object, domain, commandClass, commandParameter);
    }

    public ICommand baseCreateCommand(Object object, IEditingDomain domain, java.lang.Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
        if (commandClass == SetCommand.class) {
            return this.createSetCommand(domain, commandParameter.getOwner(), commandParameter.getProperty(), commandParameter.getValue(), commandParameter.getIndex());
        }
        if (commandClass == CopyCommand.class) {
            return this.createCopyCommand(domain, commandParameter.getOwner(), (CopyCommand.Helper)commandParameter.getValue());
        }
        if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getProperty();
            return this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand createSetCommand(IEditingDomain domain, Object owner, Object feature, Object value, int index) {
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand createCopyCommand(IEditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand createDragAndDropCommand(IEditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new DragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    protected IAdapterFactory getRootAdapterFactory() {
        return this.adapterFactory instanceof IComposeableAdapterFactory ? ((IComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory() : this.adapterFactory;
    }

    @Override
    public boolean isInferred() {
        return false;
    }

    protected class ReplacementAffectedObjectCommand
    extends CommandWrapper {
        public ReplacementAffectedObjectCommand(ICommand command) {
            super(command);
        }

        public Collection<?> getAffectedObjects() {
            Collection<Object> children = Collections.EMPTY_LIST;
            Object adapter = WrapperItemProvider.this.adapterFactory.adapt(WrapperItemProvider.this.owner, IEditingDomainItemProvider.class);
            if (adapter instanceof IEditingDomainItemProvider) {
                children = ((IEditingDomainItemProvider)adapter).getChildren(WrapperItemProvider.this.owner);
            } else {
                adapter = WrapperItemProvider.this.adapterFactory.adapt(WrapperItemProvider.this.owner, ITreeItemContentProvider.class);
                if (adapter instanceof ITreeItemContentProvider) {
                    children = ((ITreeItemContentProvider)adapter).getChildren(WrapperItemProvider.this.owner);
                }
            }
            for (Object child : children) {
                IWrapperItemProvider wrapper;
                if (!(child instanceof IWrapperItemProvider) || (wrapper = (IWrapperItemProvider)child).getProperty() != WrapperItemProvider.this.property || wrapper.getIndex() != WrapperItemProvider.this.index) continue;
                return Collections.singletonList(child);
            }
            return Collections.EMPTY_LIST;
        }
    }

    protected class WrapperItemPropertyDescriptor
    extends ItemPropertyDescriptor {
        public WrapperItemPropertyDescriptor(IResourceLocator resourceLocator, IReference property) {
            super(WrapperItemProvider.this.adapterFactory, resourceLocator, WrapperItemProvider.this.getPropertyName(), WrapperItemProvider.this.getPropertyDescription(), property, WrapperItemProvider.this.isPropertySettable(), WrapperItemProvider.this.isPropertyMultiLine(), WrapperItemProvider.this.isPropertySortChoices(), WrapperItemProvider.this.getPropertyImage(), WrapperItemProvider.this.getPropertyCategory(), WrapperItemProvider.this.getPropertyFilterFlags());
        }

        @Override
        public Object getPropertyValue(Object object) {
            return super.getPropertyValue(WrapperItemProvider.this.owner);
        }

        @Override
        public boolean canSetProperty(Object object) {
            return super.canSetProperty(WrapperItemProvider.this.owner);
        }

        @Override
        public boolean isPropertySet(Object object) {
            return true;
        }

        @Override
        public void resetPropertyValue(Object object) {
        }

        @Override
        public void setPropertyValue(Object object, Object value) {
            IEditingDomain editingDomain = this.getEditingDomain(WrapperItemProvider.this.owner);
            if (editingDomain == null) {
                this.setValue((IResource)object, this.property, value);
            } else {
                try {
                    editingDomain.getCommandStack().execute(this.createSetCommand(editingDomain, (IResource)object, this.property, value), null, null);
                }
                catch (ExecutionException e) {
                    KommaEditPlugin.getPlugin().log(new Status(4, "net.enilink.komma.edit", "Error while setting property value", (Throwable)e));
                }
            }
        }

        @Override
        protected Object getValue(IResource object, IReference property) {
            Object result = object.get(property);
            if ((Integer)object.getApplicableCardinality(property).getSecond() != 1) {
                List list = (List)result;
                result = WrapperItemProvider.this.index >= 0 && WrapperItemProvider.this.index < list.size() ? list.get(WrapperItemProvider.this.index) : WrapperItemProvider.this.value;
            }
            return result;
        }

        protected void setValue(IResource object, IReference property, Object value) {
            if ((Integer)object.getApplicableCardinality(property).getSecond() != 1) {
                List list = (List)object.get(property);
                list.set(WrapperItemProvider.this.index, value);
            } else {
                object.set(property, value);
            }
        }

        protected ICommand createSetCommand(IEditingDomain domain, Object owner, Object feature, Object value) {
            return SetCommand.create(domain, this.getCommandOwner(WrapperItemProvider.this), null, value);
        }

        @Override
        public boolean isMany(Object object) {
            return false;
        }

        @Override
        public Collection<?> getChoiceOfValues(Object object) {
            return super.getChoiceOfValues(WrapperItemProvider.this.owner);
        }
    }

    protected abstract class WrappingCopyCommand
    extends CommandWrapper {
        protected Collection<?> affectedObjects;

        public WrappingCopyCommand(ICommand command) {
            super(command);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            super.doExecuteWithResult(progressMonitor, info);
            IWrapperItemProvider copy = this.copy();
            copy.dispose();
            return CommandResult.newOKCommandResult(Collections.singletonList(copy));
        }

        public abstract IWrapperItemProvider copy();

        public Collection<?> getAffectedObjects() {
            if (this.affectedObjects == null) {
                this.affectedObjects = Collections.singletonList(WrapperItemProvider.this);
            }
            return this.affectedObjects;
        }
    }

    protected abstract class SimpleCopyCommand
    extends AbstractOverrideableCommand {
        protected Collection<?> affectedObjects;

        public SimpleCopyCommand(IEditingDomain domain) {
            super(domain, COPY_COMMAND_LABEL, COPY_COMMAND_DESCRIPTION);
        }

        protected boolean prepare() {
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            IWrapperItemProvider copy = this.copy();
            copy.dispose();
            return CommandResult.newOKCommandResult(Collections.singletonList(copy));
        }

        public abstract IWrapperItemProvider copy();

        @Override
        public Collection<?> doGetAffectedObjects() {
            if (this.affectedObjects == null) {
                this.affectedObjects = Collections.singletonList(WrapperItemProvider.this);
            }
            return this.affectedObjects;
        }
    }
}

