/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.util;

import java.util.LinkedList;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.util.Pair;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.ICompositeCommand;
import net.enilink.komma.common.command.SimpleCommand;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class PropertyUtil {
    public static ICommand getAddCommand(IEditingDomain editingDomain, IResource subject, IProperty predicate, Object object) {
        return PropertyUtil.getAddCommand(editingDomain, subject, predicate, object, -1);
    }

    public static ICommand getAddCommand(IEditingDomain editingDomain, IResource subject, IProperty predicate, Object object, int index) {
        Pair cardinality = subject.getApplicableCardinality((IReference)predicate);
        ICommand addCommand = (Integer)cardinality.getSecond() != 1 ? AddCommand.create(editingDomain, (Object)subject, (Object)predicate, object, index) : SetCommand.create(editingDomain, subject, predicate, object, index);
        return addCommand;
    }

    public static ICommand getRemoveCommand(IEditingDomain editingDomain, final IResource subject, IProperty property, final Object object) {
        ICommand removeCommand = RemoveCommand.create(editingDomain, (Object)subject, (Object)property, object);
        removeCommand = removeCommand.compose((IUndoableOperation)new SimpleCommand(){

            protected boolean canDelete(IEntityManager em, IReference deletedSubject, Object object2) {
                if (!(object2 instanceof IReference) || ((IReference)object2).getURI() != null) {
                    return false;
                }
                IExtendedIterator refs = em.matchAsserted(null, null, (IValue)((IReference)object2));
                boolean canDelete = true;
                for (IStatement refStmt : refs) {
                    if (refStmt.getSubject().equals(deletedSubject)) continue;
                    canDelete = false;
                    break;
                }
                refs.close();
                return canDelete;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                IEntityManager em = subject.getEntityManager();
                if (this.canDelete(em, (IReference)subject, object)) {
                    LinkedList<IReference> bnodes = new LinkedList<IReference>();
                    bnodes.add((IReference)object);
                    while (!bnodes.isEmpty()) {
                        IReference node = (IReference)bnodes.remove();
                        for (IStatement stmt : em.matchAsserted(node, null, null)) {
                            Object o = stmt.getObject();
                            if (!this.canDelete(em, node, o)) continue;
                            bnodes.add((IReference)o);
                        }
                        em.remove((Object)node);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return removeCommand;
    }

    public static int getRemovedIndex(IUndoableOperation operation) {
        Integer index = PropertyUtil.findRemovedIndex(operation);
        return index != null ? index : -1;
    }

    private static Integer findRemovedIndex(IUndoableOperation operation) {
        if (operation instanceof RemoveCommand) {
            int[] indices = ((RemoveCommand)operation).getIndices();
            return indices != null && indices.length > 0 ? indices[0] : -1;
        }
        if (operation instanceof ICompositeCommand) {
            for (IUndoableOperation child : (ICompositeCommand)operation) {
                Integer index = PropertyUtil.findRemovedIndex(child);
                if (index == null) continue;
                return index;
            }
        }
        return null;
    }
}

