/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.liftweb.common.Box;
import net.liftweb.common.Empty$;
import net.liftweb.common.EmptyBox;
import net.liftweb.common.Failure;
import net.liftweb.common.Full;
import net.liftweb.common.Logger;
import net.liftweb.common.Logger$;
import net.liftweb.util.ControlHelpers;
import net.liftweb.util.TimeHelpers;
import net.liftweb.util.TimeHelpers$;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class TimeHelpers$class {
    public static Logger net$liftweb$util$TimeHelpers$$logger(TimeHelpers $this) {
        return Logger$.MODULE$.apply(TimeHelpers.class);
    }

    public static TimeHelpers.TimeSpanBuilder longToTimeSpanBuilder(TimeHelpers $this, long in2) {
        return new TimeHelpers.TimeSpanBuilder($this, in2);
    }

    public static TimeHelpers.TimeSpanBuilder intToTimeSpanBuilder(TimeHelpers $this, int in2) {
        return new TimeHelpers.TimeSpanBuilder($this, in2);
    }

    public static TimeHelpers.TimeSpan longToTimeSpan(TimeHelpers $this, long in2) {
        return $this.TimeSpan().apply(in2);
    }

    public static TimeHelpers.TimeSpan intToTimeSpan(TimeHelpers $this, int in2) {
        return $this.TimeSpan().apply(in2);
    }

    public static Period net$liftweb$util$TimeHelpers$$durToPeriod(TimeHelpers $this, Duration dur) {
        return dur.toPeriod(PeriodType.standard());
    }

    public static long nano(TimeHelpers $this) {
        return System.nanoTime();
    }

    public static long millis(TimeHelpers $this) {
        return System.currentTimeMillis();
    }

    public static long seconds(TimeHelpers $this, long in2) {
        return in2 * 1000L;
    }

    public static long minutes(TimeHelpers $this, long in2) {
        return $this.seconds(in2) * 60L;
    }

    public static long hours(TimeHelpers $this, long in2) {
        return $this.minutes(in2) * 60L;
    }

    public static long days(TimeHelpers $this, long in2) {
        return $this.hours(in2) * 24L;
    }

    public static long weeks(TimeHelpers $this, long in2) {
        return $this.days(in2) * 7L;
    }

    public static TimeHelpers.DateExtension toDateExtension(TimeHelpers $this, Date d) {
        return new TimeHelpers.DateExtension($this, d);
    }

    public static TimeHelpers.CalendarExtension toCalendarExtension(TimeHelpers $this, Calendar c) {
        return new TimeHelpers.CalendarExtension($this, c);
    }

    public static Date now(TimeHelpers $this) {
        return new Date();
    }

    public static Calendar today(TimeHelpers $this) {
        return $this.toCalendarExtension(Calendar.getInstance()).noTime();
    }

    public static int currentYear(TimeHelpers $this) {
        return Calendar.getInstance().get(1);
    }

    public static Date timeNow(TimeHelpers $this) {
        return new Date();
    }

    public static Date dayNow(TimeHelpers $this) {
        return $this.intToTimeSpanBuilder(0).seconds().later().noTime();
    }

    public static Date time(TimeHelpers $this, long when) {
        return new Date(when);
    }

    public static int month(TimeHelpers $this, Date in2) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in2.getTime());
        return cal.get(2);
    }

    public static int year(TimeHelpers $this, Date in2) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in2.getTime());
        return cal.get(1);
    }

    public static int day(TimeHelpers $this, Date in2) {
        Calendar cal = Calendar.getInstance($this.utc());
        cal.setTimeInMillis(in2.getTime());
        return cal.get(5);
    }

    public static long millisToDays(TimeHelpers $this, long millis) {
        return millis / 86400000L;
    }

    public static long daysSinceEpoch(TimeHelpers $this) {
        return $this.millisToDays($this.millis());
    }

    public static Tuple2 calcTime(TimeHelpers $this, Function0 f) {
        long start = $this.millis();
        Object result = f.apply();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)($this.millis() - start)), result);
    }

    public static Object logTime(TimeHelpers $this, String msg, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 != null) {
            Tuple2 tuple22;
            long time = tuple2._1$mcJ$sp();
            Object ret = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), ret);
            long time2 = tuple23._1$mcJ$sp();
            Object ret2 = tuple23._2();
            $this.net$liftweb$util$TimeHelpers$$logger().info((Function0<Object>)new Serializable($this, time2, msg){
                private final long time$1;
                private final String msg$2;

                public final String apply() {
                    return new StringBuilder().append((Object)this.msg$2).append((Object)" took ").append((Object)BoxesRunTime.boxToLong((long)this.time$1)).append((Object)" Milliseconds").toString();
                }
                {
                    this.time$1 = time$1;
                    this.msg$2 = msg$2;
                }
            });
            return ret2;
        }
        throw new MatchError(tuple2);
    }

    public static Object logTime(TimeHelpers $this, Function0 f) {
        Tuple2 tuple2 = $this.calcTime(f);
        if (tuple2 != null) {
            Tuple2 tuple22;
            long time = tuple2._1$mcJ$sp();
            Tuple2 fret = (Tuple2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)fret);
            long time2 = tuple23._1$mcJ$sp();
            Tuple2 fret2 = (Tuple2)tuple23._2();
            Tuple2 tuple24 = fret2;
            if (tuple24 != null) {
                Tuple2 tuple25;
                String msg = (String)tuple24._1();
                Object ret = tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)msg, ret);
                String msg2 = (String)tuple26._1();
                Object ret2 = tuple26._2();
                $this.net$liftweb$util$TimeHelpers$$logger().info((Function0<Object>)new Serializable($this, time2, msg2){
                    private final long time$2;
                    private final String msg$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.msg$1).append((Object)" took ").append((Object)BoxesRunTime.boxToLong((long)this.time$2)).append((Object)" Milliseconds").toString();
                    }
                    {
                        this.time$2 = time$2;
                        this.msg$1 = msg$1;
                    }
                });
                return ret2;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError(tuple2);
    }

    public static SimpleDateFormat hourFormat(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static String hourFormat(TimeHelpers $this, Date in2) {
        return $this.hourFormat().format(in2);
    }

    public static SimpleDateFormat dateFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static SimpleDateFormat timeFormatter(TimeHelpers $this) {
        return new SimpleDateFormat("HH:mm zzz");
    }

    public static String formattedDateNow(TimeHelpers $this) {
        return $this.dateFormatter().format($this.now());
    }

    public static String formattedTimeNow(TimeHelpers $this) {
        return $this.timeFormatter().format($this.now());
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleDateFormat internetDateFormatter(TimeHelpers $this) {
        void var1_1;
        SimpleDateFormat ret = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        ret.setTimeZone($this.utc());
        return var1_1;
    }

    public static Box boxParseInternetDate(TimeHelpers $this, String dateString) {
        return ((ControlHelpers)((Object)$this)).tryo(new Serializable($this, dateString){
            private final /* synthetic */ TimeHelpers $outer;
            private final String dateString$1;

            public final Date apply() {
                return this.$outer.internetDateFormatter().parse(this.dateString$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dateString$1 = dateString$1;
            }
        });
    }

    public static Date parseInternetDate(TimeHelpers $this, String dateString) {
        return (Date)((ControlHelpers)((Object)$this)).tryo(new Serializable($this, dateString){
            private final /* synthetic */ TimeHelpers $outer;
            private final String dateString$2;

            public final Date apply() {
                return this.$outer.internetDateFormatter().parse(this.dateString$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dateString$2 = dateString$2;
            }
        }).openOr(new Serializable($this){

            public final Date apply() {
                return new Date(0L);
            }
        });
    }

    public static String toInternetDate(TimeHelpers $this, Date in2) {
        return $this.internetDateFormatter().format(in2);
    }

    public static String toInternetDate(TimeHelpers $this, long in2) {
        return $this.internetDateFormatter().format(new Date(in2));
    }

    public static String nowAsInternetDate(TimeHelpers $this) {
        return $this.toInternetDate($this.millis());
    }

    public static Box toDate(TimeHelpers $this, Object in2) {
        EmptyBox emptyBox;
        try {
            Box box;
            Object object = in2;
            if (object == null) {
                box = Empty$.MODULE$;
            } else if (object instanceof Date) {
                Date date = (Date)object;
                box = new Full<Date>(date);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                box = new Full<Date>(new Date(l));
            } else if (object instanceof Number) {
                Number number2 = (Number)object;
                box = new Full<Date>(new Date(number2.longValue()));
            } else {
                boolean bl = Nil$.MODULE$.equals(object) ? true : (((Object)Empty$.MODULE$).equals(object) ? true : (None$.MODULE$.equals(object) ? true : object instanceof Failure));
                if (bl) {
                    box = Empty$.MODULE$;
                } else if (object instanceof Full) {
                    Full full = (Full)object;
                    Object v = full.value();
                    box = $this.toDate(v);
                } else if (object instanceof Some) {
                    Some some = (Some)object;
                    Object v = some.x();
                    box = $this.toDate(v);
                } else if (object instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)object;
                    Object v = colon2.head();
                    box = $this.toDate(v);
                } else if (object instanceof String) {
                    String string2 = (String)object;
                    box = ((ControlHelpers)((Object)$this)).tryo(new Serializable($this, string2){
                        private final /* synthetic */ TimeHelpers $outer;
                        private final String x16$1;

                        public final Date apply() {
                            return this.$outer.internetDateFormatter().parse(this.x16$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x16$1 = x16$1;
                        }
                    }).or(new Serializable($this, string2){
                        private final /* synthetic */ TimeHelpers $outer;
                        public final String x16$1;

                        public final Box<Date> apply() {
                            return ((ControlHelpers)((Object)this.$outer)).tryo(new Serializable(this){
                                private final /* synthetic */ TimeHelpers$.anonfun.toDate.2 $outer;

                                public final Date apply() {
                                    return this.$outer.net$liftweb$util$TimeHelpers$$anonfun$$$outer().dateFormatter().parse(this.$outer.x16$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ TimeHelpers net$liftweb$util$TimeHelpers$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x16$1 = x16$1;
                        }
                    });
                } else {
                    box = $this.toDate(object.toString());
                }
            }
            emptyBox = box;
        }
        catch (Exception exception) {
            $this.net$liftweb$util$TimeHelpers$$logger().debug((Function0<Object>)new Serializable($this, in2){
                private final Object in$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Error parsing date ").append(this.in$1).toString();
                }
                {
                    this.in$1 = in$1;
                }
            }, exception);
            emptyBox = new Failure(new StringBuilder().append((Object)"Bad date: ").append(in2).toString(), new Full<Throwable>(exception), Empty$.MODULE$);
        }
        return emptyBox;
    }

    public static void $init$(TimeHelpers $this) {
        $this.net$liftweb$util$TimeHelpers$_setter_$net$liftweb$util$TimeHelpers$$outer_$eq($this);
        $this.net$liftweb$util$TimeHelpers$_setter_$utc_$eq(TimeZone.getTimeZone("UTC"));
    }
}

