/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.spring.gaecache;

import net.eusashead.spring.gaecache.HashAlgorithm;
import net.eusashead.spring.gaecache.Murmur3HashAlgorithm;
import org.springframework.util.Assert;

public class ArgumentHash {
    public static final String NULL_HASH = "<null>";
    private final String raw;
    private final String hash;

    public ArgumentHash() {
        this.hash = NULL_HASH;
        this.raw = null;
    }

    public ArgumentHash(String raw) {
        this(raw, new Murmur3HashAlgorithm());
    }

    public ArgumentHash(String raw, HashAlgorithm strategy) {
        Assert.notNull((Object)raw);
        Assert.notNull((Object)strategy);
        String hash = strategy.hash(raw);
        this.raw = raw;
        this.hash = hash;
    }

    public String rawValue() {
        return this.raw;
    }

    public String hashValue() {
        return this.hash;
    }

    public String toString() {
        return this.hash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentHash other = (ArgumentHash)obj;
        return !(this.hash == null ? other.hash != null : !this.hash.equals(other.hash));
    }
}

