/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.spring.gaecache;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.util.Random;
import java.util.logging.Logger;
import net.eusashead.spring.gaecache.GaeCacheKey;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class GaeCache
implements Cache {
    private static final Logger log = Logger.getLogger(GaeCache.class.getName());
    private static final String NS_PREFIX = "__NAMESPACE__";
    private final Expiration expiration;
    private final String name;
    private final String fqName;
    private final MemcacheService syncCache;

    public GaeCache(String name) {
        this(name, MemcacheServiceFactory.getMemcacheService(), Expiration.byDeltaSeconds((int)3600));
    }

    public GaeCache(String name, MemcacheService memcacheService, Expiration expiration) {
        Assert.notNull((Object)name, (String)"Name cannot be null.");
        Assert.notNull((Object)memcacheService, (String)"MemcacheService cannot be null.");
        Assert.notNull((Object)expiration, (String)"Expiration cannot be null.");
        this.name = name;
        this.fqName = NS_PREFIX + name;
        this.syncCache = memcacheService;
        this.expiration = expiration;
    }

    public void clear() {
        if (this.syncCache.contains((Object)this.fqName)) {
            log.fine(String.format("Clearing cache with name %s", this.name));
            this.syncCache.increment((Object)this.fqName, 1L);
        }
    }

    public void evict(Object key) {
        Assert.notNull((Object)key);
        Assert.isAssignable(GaeCacheKey.class, key.getClass());
        GaeCacheKey cacheKey = (GaeCacheKey)GaeCacheKey.class.cast(key);
        Integer namespaceKey = this.getNamespaceKey();
        String nsKey = this.getKey(namespaceKey, cacheKey);
        log.fine(String.format("Deleting key %s (%s) from namespace %s (namespace key: %s)", cacheKey.hashValue(), cacheKey.rawValue(), this.name, namespaceKey));
        this.syncCache.delete((Object)nsKey);
    }

    public Cache.ValueWrapper get(Object key) {
        Assert.notNull((Object)key);
        Assert.isAssignable(GaeCacheKey.class, key.getClass());
        GaeCacheKey cacheKey = (GaeCacheKey)GaeCacheKey.class.cast(key);
        Integer namespaceKey = this.getNamespaceKey();
        String nsKey = this.getKey(namespaceKey, cacheKey);
        Object value = this.syncCache.get((Object)nsKey);
        log.fine(String.format("Retrieving key %s (%s) from namespace %s (namespace key: %s), got %s", cacheKey.hashValue(), cacheKey.rawValue(), this.name, namespaceKey, value));
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    public void put(Object key, Object value) {
        Assert.notNull((Object)key);
        Assert.isAssignable(GaeCacheKey.class, key.getClass());
        GaeCacheKey cacheKey = (GaeCacheKey)GaeCacheKey.class.cast(key);
        Integer namespaceKey = this.getNamespaceKey();
        String nsKey = this.getKey(namespaceKey, cacheKey);
        log.fine(String.format("Caching key %s (%s) from namespace %s (namespace key: %s), with %s", cacheKey.hashValue(), cacheKey.rawValue(), this.name, namespaceKey, value));
        this.syncCache.put((Object)nsKey, value, this.expiration);
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.syncCache;
    }

    private Integer getNamespaceKey() {
        Integer nsKey = (Integer)this.syncCache.get((Object)this.fqName);
        if (nsKey == null) {
            nsKey = new Random().nextInt(Integer.MAX_VALUE);
            log.fine(String.format("Creating namespace key %s in cache %s", nsKey, this.name));
            this.syncCache.put((Object)this.fqName, (Object)nsKey);
        }
        return nsKey;
    }

    private String getKey(Integer namespaceKey, GaeCacheKey key) {
        return String.valueOf(this.fqName) + "_" + namespaceKey.toString() + "_" + key.hashValue();
    }
}

