/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.spring.gaecache;

import java.util.Arrays;
import net.eusashead.spring.gaecache.ArgumentHash;
import org.springframework.util.Assert;

public class GaeCacheKey {
    private final ArgumentHash[] hashes;

    public GaeCacheKey(ArgumentHash arg) {
        this(new ArgumentHash[]{arg});
    }

    public GaeCacheKey(ArgumentHash[] args) {
        Assert.notNull((Object)args);
        Assert.notEmpty((Object[])args);
        Assert.noNullElements((Object[])args);
        this.hashes = args;
    }

    public String hashValue() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.hashes.length) {
            ArgumentHash hash = this.hashes[i];
            if (hash == null) {
                b.append("<null>");
            } else {
                b.append(hash.hashValue());
            }
            if (i < this.hashes.length - 1) {
                b.append("-");
            }
            ++i;
        }
        return b.toString();
    }

    public String rawValue() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.hashes.length) {
            ArgumentHash hash = this.hashes[i];
            if (hash == null) {
                b.append("null");
            } else {
                b.append(hash.rawValue());
            }
            if (i < this.hashes.length - 1) {
                b.append(",");
            }
            ++i;
        }
        return b.toString();
    }

    public String toString() {
        return this.hashValue();
    }

    public static GaeCacheKey create(String raw) {
        return raw != null ? new GaeCacheKey(new ArgumentHash(raw)) : new GaeCacheKey(new ArgumentHash());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.hashes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GaeCacheKey other = (GaeCacheKey)obj;
        return Arrays.equals(this.hashes, other.hashes);
    }
}

