/*
 * Decompiled with CFR 0.152.
 */
package net.eusashead.spring.gaecache;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.eusashead.spring.gaecache.ArgumentHash;
import net.eusashead.spring.gaecache.ArgumentHashStrategy;
import net.eusashead.spring.gaecache.DefaultArgumentHashStrategy;
import net.eusashead.spring.gaecache.GaeCacheKey;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.Assert;

public class GaeCacheKeyGenerator
implements KeyGenerator {
    private final DefaultArgumentHashStrategy defaultKeyStrategy = new DefaultArgumentHashStrategy();
    private final Map<Class<?>, ArgumentHashStrategy<?>> strategies = new HashMap();

    public Object generate(Object target, Method method, Object ... args) {
        ArgumentHash[] argumentHashArray;
        if (args.length == 0) {
            ArgumentHash[] argumentHashArray2 = new ArgumentHash[1];
            argumentHashArray = argumentHashArray2;
            argumentHashArray2[0] = new ArgumentHash();
        } else {
            argumentHashArray = new ArgumentHash[args.length];
        }
        ArgumentHash[] hashes = argumentHashArray;
        int i = 0;
        while (i < args.length) {
            ArgumentHash hash;
            Object obj = args[i];
            hashes[i] = obj == null ? new ArgumentHash() : (hash = this.getHash(obj));
            ++i;
        }
        return new GaeCacheKey(hashes);
    }

    private ArgumentHash getHash(Object object) {
        Class<?> type = object.getClass();
        ArgumentHashStrategy<?> strat = this.strategies.get(type);
        if (strat != null) {
            return strat.hash(object);
        }
        return this.defaultKeyStrategy.hash(object);
    }

    public <T> void registerStrategy(Class<T> type, ArgumentHashStrategy<T> strategy) {
        Assert.notNull(type);
        Assert.notNull(strategy);
        this.strategies.put(type, strategy);
    }
}

