/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.extras;

import java.util.Objects;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.objectweb.asm.commons.Remapper;

public final class MappingTreeRemapper
extends Remapper {
    private final MappingTreeView tree;
    private final int fromId;
    private final int toId;

    public MappingTreeRemapper(MappingTreeView tree, String from, String to) {
        Objects.requireNonNull(tree, "Mapping tree cannot be null");
        Objects.requireNonNull(from, "Input namespace cannot be null");
        Objects.requireNonNull(to, "Output namespace cannot be null");
        this.tree = tree;
        this.fromId = MappingTreeRemapper.getNamespaceId(tree, from);
        this.toId = MappingTreeRemapper.getNamespaceId(tree, to);
    }

    private static int getNamespaceId(MappingTreeView tree, String namespace) {
        int id = tree.getNamespaceId(namespace);
        if (id == -2) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' not present in mapping tree. Available: src: " + tree.getSrcNamespace() + ", dst: " + tree.getDstNamespaces());
        }
        return id;
    }

    private String getNameOrDefault(MappingTreeView.ElementMappingView element, String defaultValue) {
        String targetName = element.getName(this.toId);
        return targetName != null ? targetName : defaultValue;
    }

    public String map(String internalName) {
        return this.tree.mapClassName(internalName, this.fromId, this.toId);
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        MappingTreeView.ClassMappingView ownerMapping = this.tree.getClass(owner, this.fromId);
        if (ownerMapping == null) {
            return name;
        }
        MappingTreeView.MethodMappingView mapping = ownerMapping.getMethod(name, descriptor, this.fromId);
        return mapping != null ? this.getNameOrDefault((MappingTreeView.ElementMappingView)mapping, name) : name;
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        MappingTreeView.ClassMappingView ownerMapping = this.tree.getClass(owner, this.fromId);
        if (ownerMapping == null) {
            return name;
        }
        MappingTreeView.FieldMappingView mapping = ownerMapping.getField(name, descriptor, this.fromId);
        return mapping != null ? this.getNameOrDefault((MappingTreeView.ElementMappingView)mapping, name) : name;
    }

    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }
}

